/**
 * PWE form of GetProcessDataFromPredefinedQuery application, setter, and action
 */
PWE.integrationComponent.registerApplication( 'processdata-from-query', {
    apiVersion : 2,
    buildForm: function( form , options ) {
    	form.addField("database");
        form.addField("queryTable");
        addTypeOfQueryComboBox(form);
        form.addField("queryName");
        form.addField("queryParams");
        form.addField({ id: "targetVariables" });
        addMultipleValuesHandlingMethods(form);
        form.addField({
            id: "commentError",
            hidden: true
        });
        form.addField("overwrite");
        if(form.getValue("commentError")){
            form.show("commentError");
        }
        if (form.getValue("typeOfQuery") != "SELECT") {
        	form.hide("targetVariables");
            form.hide("multiVals");
            form.hide("overwrite");
        }
    }
});

PWE.integrationComponent.registerVariablesSetter( 'processdata-from-query-setter', {
	apiVersion : 2,
    buildForm: function( form , options ) {
    	form.addField("database");
        form.addField("queryTable");
        addTypeOfQueryComboBox(form);
        form.addField("queryName");
        form.addField("queryParams");
        form.addField("targetVariables");
        addMultipleValuesHandlingMethods(form);
        form.addField("overwrite");
        if (form.getValue("typeOfQuery") != "SELECT") {
        	form.hide("targetVariables");
            form.hide("multiVals");
            form.hide("overwrite");
        }
        form.addField("cancelAcceptance");
    }
});

PWE.integrationComponent.registerFormAction( 'processdata-from-query-action', {
	apiVersion : 2,
    buildForm: function( form , options ) {
    	form.addField("database");
        form.addField("queryTable");
        form.addField("queryName");
        form.addField("queryParams");
        form.addField("targetVariables");
        form.addField("dynamicTableId");
        addMultipleValuesHandlingMethods(form);
        form.addField("overwrite");
        form.hide("overwrite");
        form.addCombobox({
    		id : "wayOfAdding",
    		values : [
    		          {id : "OVERWRITE_ALL_COLUMNS", display : CUFCommon.t("predefined.wayOfAdding.overwrite_all_columns")},
    		          {id : "OVERWRITE_UPDATED_COLUMNS", display : CUFCommon.t("predefined.wayOfAdding.overwrite_updated_column")},
    		          {id : "ADD", display : CUFCommon.t("predefined.wayOfAdding.add")}
    		]
    	});
        if (form.getValue("wayOfAdding") == "UNSET"){
        	var overwrite = form.getValue("overwrite", false);
        	form.setValue("wayOfAdding", overwrite ? "OVERWRITE_ALL_COLUMNS" : "ADD");
        }
    }
});

function addDbCombobox(form, fieldId) {
	var	url = prepareUrl(),
		position = form.getFieldPosition(fieldId);
	
	jQuery.ajax({
		type : "GET",
		url : url,
		async : true
	})
	.done(function (data){
		var values = prepareValuesArray(data.replace(/\[|]/g, "").split(','));
		form.removeField(fieldId);
		form.insertCombobox(position, {
            id : "database",
            values : values
        });
	});
};

function prepareUrl() {
	var href = window.location.href;
	var url = href.replace("com.suncode.plugin-pwe", "com.suncode-cuf-components") + "dbconf/aliases/"; 
	return url;
};

function prepareValuesArray(aliases) {
	var values = [];
	for (var i=0; i<aliases.length; i++) {
		values.push({id : aliases[i], display : aliases[i]});
	}
	return values;
};

function addMultipleValuesHandlingMethods(form) {
	form.addCombobox({
		id : "multiVals",
		values : [
		          {id : "BLOCK", display : CUFCommon.t("predefined.multivals.block")},
		          {id : "UNIQUE", display : CUFCommon.t("predefined.multivals.unique")},
		          {id : "FIRST", display : CUFCommon.t("predefined.multivals.first")}
		]
	});
};

function addTypeOfQueryComboBox(form){
	form.addCombobox({
		id : "typeOfQuery",
		values : [
		          {id : "SELECT", display : CUFCommon.t("predefined.typeOfQuery.select")},
		          {id : "UPDATE", display : CUFCommon.t("predefined.typeOfQuery.update")}
		],
		listeners: {
            change: function (value) {
                if (value == "SELECT") {
                    form.show("targetVariables");
                    form.show("multiVals");
                    form.show("overwrite");
                }
                else {
                    form.hide("targetVariables");
                    form.hide("multiVals");
                    form.hide("overwrite");
                }
            }
        }
		          
	});
};