PWE.integrationComponent.registerFormAction('exchange-rate-action', {
    apiVersion: 2,
    buildForm: function (form) {
        form.addField('currency');
        form.addField('date');
        form.addField('dateOffset');
        form.addField('effectiveDate');
        form.addCombobox({
            id: 'executeTypes',
            values: [
                {id: 'UPDATING_VARIABLES', display: CUFCommon.t('action.set-variables.execute-type.updating-variables')},
                {id: 'CONDITIONAL_EXECUTE', display: CUFCommon.t('action.set-variables.execute-type.conditional-execute')},
                {id: 'CURRENCY_OR_DATE_UPDATE', display: CUFCommon.t('action.exchange-rate-action.execute-type.curr-date-update')}
            ],
            listeners: {
                change: function () {
                    var fullValue = form.getValue('executeTypes');
                    if (fullValue.indexOf('UPDATING_VARIABLES') > -1) {
                        form.show('updatingVariables');
                        form.setNotEmpty('updatingVariables', true);
                    } else {
                        form.resetArray('updatingVariables');
                        form.hide('updatingVariables');
                        form.setNotEmpty('updatingVariables', false);
                    }
                }
            },
            notEmpty: true
        });
        form.addField({
            id: 'updatingVariables',
            notEmpty: true
        });
        form.addField("tableNo");
        form.addField("tableName");
        if (!(form.getValue('executeTypes').indexOf('UPDATING_VARIABLES') > -1)) {
            form.resetArray('updatingVariables');
            form.hide('updatingVariables');
            form.setNotEmpty('updatingVariables', false);
        }
    }
});

PWE.integrationComponent.registerApplication('exchange-rate-duals', {
    apiVersion: 2,
    buildForm: function (form) {
        const table = form.addTable({
            notEmpty: true
        });
        table.addField('currencies');
        table.addField('dates');
        form.addField('dateOffset');
        form.addField('effectiveDate');
        form.addField('exchange');
        form.addField('tableNo');
        form.addField('tableType');
    },
    validateForm: function (api) {
        return validParametersType(api);
    }
});

PWE.integrationComponent.registerVariablesSetter('exchange-rate-duals', {
    apiVersion: 2,
    buildForm: function (form) {
        const table = form.addTable({
            notEmpty: true
        });
        table.addField('currencies');
        table.addField('dates');
        form.addField('dateOffset');
        form.addField('effectiveDate');
        form.addField('exchange');
        form.addField('tableNo');
        form.addField('tableType');
    },
    validateForm: function (api) {
        return validParametersType(api);
    }
});

function validParametersType(api) {
    let valid = true;

    if (api.getVariableType('exchange') !== 'float[]' && api.getVariableType('exchange') !== 'float') {
        api.showErrorMessage(CUFCommon.t('form-valid-float'));
        api.markError('exchange')
        return false;
    }
    if (api.getValue('tableNo') !== '' && api.getVariableType('tableNo') !== 'string[]' && api.getVariableType('tableNo') !== 'string') {
        api.markError('tableNo')
        valid = false;
    }
    if (api.getValue('tableType') !== '' && api.getVariableType('tableType') !== 'string[]' && api.getVariableType('tableType') !== 'string') {
        api.markError('tableType')
        valid = false;
    }
    if (api.getValue("effectiveDate") !== "" && api.getVariableType("effectiveDate") !== "date[]" && api.getVariableType("effectiveDate") !== "date") {
        api.markError("effectiveDate");
        valid = false;
    }

    if (!valid) {
        api.showErrorMessage(CUFCommon.t('form-valid-string'));
    }

    return valid;
}