PWE.integrationComponent.registerValidator('db-validator', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField({ id: "acceptResults",
            hidden: true
        });
        
        form.addCombobox({
            name: CUFCommon.t("db-validator.accept-result-combobox"),
            description: CUFCommon.t("db-validator.accept-result-combobox.desc"),
            id: "acceptResultCombobox",
            value: form.getValue("acceptResults") ? "true" : "false",
            values: [
                { 
                    id: "true",
                    display: CUFCommon.t("db-validator.accept-result-true"), 
                    description: CUFCommon.t("db-validator.accept-result-true.desc") 
                },
                { 
                    id: "false",
                    display: CUFCommon.t("db-validator.accept-result-false"),
                    description: CUFCommon.t("db-validator.accept-result-false.desc") 
                }
            ],
            listeners: {
                change: function (value) {
                    if (value == "true") {
                        form.setValue("acceptResults", true);
                    }
                    else {
                        form.setValue("acceptResults", false);
                    }
                }
            }
        });
        form.addField("dbName");
        CufComp.obtainDataBaseAliases("dbName", form);
        form.addField("queryName");
        form.addField("variablesParams");
        var table2 = form.addTable({
            id: "customTable2"
        });
        table2.addField("queryParams");
        
        table2.addCombobox({
            id: "queryParamsTypes",
            values: [
                { id: "string", display: CUFCommon.t("db-validator.query-param-type.text") },
                { id: "integer", display: CUFCommon.t("db-validator.query-param-type.integer") },
                { id: "float", display: CUFCommon.t("db-validator.query-param-type.float") },
                { id: "boolean", display: CUFCommon.t("db-validator.query-param-type.boolean") },
                { id: "date", display: CUFCommon.t("db-validator.query-param-type.date") },
                { id: "datetime", display: CUFCommon.t("db-validator.query-param-type.date-time") }
            ]
        });
        
        form.addCombobox({
            id: "messageType",
            values: [
                { id: "global", display: CUFCommon.t("function-based-validator.global") },
                { id: "local", display: CUFCommon.t("function-based-validator.local") },
                { id: "localandglobal", display: CUFCommon.t("function-based-validator.localandglobal") }
            ],
            listeners: {
                change: function (value) {
                    if (value == "global") {
                        table.clear();
                        form.hide("customTable");
                        form.show("confirmation");
                        form.show("alert");
                        form.setNotEmpty("errorVariables", false);
                        form.setNotEmpty("errorVariablesMessages", false);
                    }
                    else if (value == "local") {
                        form.show("customTable");
                        form.hide("confirmation");
                        form.hide("alert");
                        form.setValue("alert", "");
                        form.setValue("confirmation", false);
                        form.setNotEmpty("errorVariables", true);
                        form.setNotEmpty("errorVariablesMessages", true);
                    }
                    else if (value == "localandglobal") {
                        form.show("customTable");
                        form.hide("confirmation");
                        form.show("alert");
                        form.setValue("confirmation", false);
                        form.setNotEmpty("errorVariables", true);
                        form.setNotEmpty("errorVariablesMessages", true);
                    }
                }
            }
        });
        form.addField({
            id: "confirmation",
            hidden: true
        });
        form.addField({
            id: "alert",
            hidden: true
        });
        table = form.addTable({
            id: "customTable",
            hidden: true
        });
        table.addField("errorVariables");
        table.addField("errorVariablesMessages");
        
        var msgType = form.getValue("messageType");
        if (msgType == "local") {
            form.show("customTable");
            form.hide("confirmation");
            form.hide("alert");
            if(form.getValue("alert") != ""){
                form.setValue("alert", "");
            }
            form.setNotEmpty("errorVariables", true);
            form.setNotEmpty("errorVariablesMessages", true);
        }
        else if (msgType == "localandglobal") {
            form.show("customTable");
            form.hide("confirmation");
            form.show("alert");
            if(!form.getValue("confirmation")){
                form.setValue("confirmation", false);
            }
            form.setNotEmpty("errorVariables", true);
            form.setNotEmpty("errorVariablesMessages", true);
        } else {
            table.clear();
            form.hide("customTable");
            form.show("confirmation");
            form.show("alert");
            if(form.getValue("messageType") != "global"){
                form.setValue("messageType", "global");
            }
            form.setNotEmpty("errorVariables", false);
            form.setNotEmpty("errorVariablesMessages", false);
        }
    }
}); 
