/**
 * Action sets row numbers in given column.
 */
PW.FormActions.create('set-row-number', {
	variableSetInit: function(variableSet) {
		this.variableSet = variableSet;
	},
	defaultActions: {
		variableSet: function(variableSet, added, updated, removed) {
			if (added.length > 0 || removed.length > 0) {
				var startIndex = this.resolveStartIndex(added.concat(removed));
				this.numberRows(startIndex);
			}
		}
	},
	resolveStartIndex: function(records) {
		var startIndex = 0;
		PW.each(records, function(record) {
			if (record.index < startIndex) {
				startIndex = index;
			}
		});
		return startIndex;
	},
	enable: function() {
		this.numberRows(0);
	},
	numberRows: function(startIndex) {
		var initialValue = this.get("initialValue");
		var increaseBy = this.get("increaseBy");

		var columnId = this.get("column").getId();
		var records = this.variableSet.getRecords();
		for (var i = startIndex; i < records.length; i++) {
			records[i].set(columnId, initialValue);
			initialValue += increaseBy;
		}
	}
});