/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils.handlers;

import com.suncode.cuf.common.utils.handlers.Handler;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class CommentHandler
implements Handler {
    private CommentService commentService;
    private String processId;
    private String activityId;
    private String message;

    @Autowired
    public CommentHandler(CommentService commentService, String processId, String activityId, String message) {
        Assert.hasText((String)processId, (String)"ProcessId must not be empty");
        Assert.hasText((String)activityId, (String)"ActivityId must not be empty");
        Assert.hasText((String)message, (String)"Comment message must not be empty");
        this.commentService = commentService;
        this.processId = processId;
        this.activityId = activityId;
        this.message = message;
    }

    @Override
    public void handle() {
        Comment comment = new Comment();
        comment.setProcessId(this.processId);
        comment.setActivityId(this.activityId);
        comment.setComment(this.message);
        comment.setUserId("admin");
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        this.commentService.createComment(comment);
    }

    protected void setActivityId(String activityId) {
        this.activityId = activityId;
    }
}

