/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.tablestore.TableStore;
import com.suncode.cuf.common.tablestore.utils.TableStoreUtils;
import com.suncode.cuf.common.utils.CommonUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.FormGrid;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-pwe/table-insert-records-form.js")
public class TableInsertRecords {
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private FormService formService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("table-insert-records-app")).name("application.table-insert-records-app.name")).description("application.table-insert-records-app.desc")).category(new Category[]{Categories.TABLESTORE})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}insert-tablestore-application")).icon((Icon)SilkIconPack.TABLE_ROW_INSERT)).parameter().id("tableStoreToInsert").name("application.table-insert-records-app.tableStoreToInsert.name").description("application.table-insert-records-app.tableStoreToInsert.desc").type((Type)Types.STRING).create()).parameter().id("mappingType").name("application.table-insert-records-app.mappingType.name").description("application.table-insert-records-app.mappingType.desc").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("application.table-insert-records-app.activityDefId.name").description("application.table-insert-records-app.activityDefId.desc").type((Type)Types.STRING).optional().create()).parameter().id("tableId").name("application.table-insert-records-app.tableId.name").description("application.table-insert-records-app.tableId.desc").type((Type)Types.STRING).optional().create()).parameter().id("mappingIds").name("application.table-insert-records-app.mappingIds.name").description("application.table-insert-records-app.mappingIds.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("mappingValues").name("application.table-insert-records-app.mappingValues.name").description("application.table-insert-records-app.mappingValues.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("overwriteData").name("application.table-insert-records-app.overwriteData.name").description("application.table-insert-records-app.overwriteData.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create();
    }

    public void execute(ActivityContextMap activityContextMap, @Param String tableStoreToInsert, @Param String mappingType, @Param String activityDefId, @Param String tableId, @PairedParam(key="mappingIds", value="mappingValues") Map<String, Variable> mappings, @Param boolean overwriteData) {
        this.handle(activityContextMap, tableStoreToInsert, mappings, overwriteData, mappingType, activityDefId, tableId);
    }

    public void set(ActivityContextMap activityContextMap, @Param String tableStoreToInsert, @Param String mappingType, @Param String activityDefId, @Param String tableId, @PairedParam(key="mappingIds", value="mappingValues") Map<String, Variable> mappings, @Param boolean overwriteData) {
        this.handle(activityContextMap, tableStoreToInsert, mappings, overwriteData, mappingType, activityDefId, tableId);
    }

    public void handle(ActivityContextMap activityContextMap, String tableStoreToInsert, Map<String, Variable> mappings, boolean overwriteData, String mappingType, String activityDefId, String tableId) {
        TableStore tableStore = TableStore.fromJson(tableStoreToInsert);
        switch (mappingType) {
            case "manual": {
                this.handleManualMappingType(tableStore, mappings, overwriteData);
                break;
            }
            case "table": {
                this.handleTableMappingType(activityContextMap, tableStore, activityDefId, tableId, overwriteData);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported mapping type: " + mappingType);
            }
        }
    }

    private void handleManualMappingType(TableStore tableStore, Map<String, Variable> mappings, boolean overwriteData) {
        this.validateMappings(tableStore.getVariableType(), mappings);
        Map<String, List> valuesToSet = tableStore.getVariableType().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, property -> new ArrayList()));
        IntStream.range(0, tableStore.getData().size()).forEach(i -> {
            Map<String, Object> oneRecord = tableStore.getData().get(i);
            oneRecord.forEach((key, value) -> {
                switch (tableStore.getVariableType().get(key)) {
                    case "date": {
                        LocalDate dateValue = value == null ? null : LocalDate.parse((String)value.toString());
                        ((List)valuesToSet.get(key)).add(dateValue);
                        break;
                    }
                    case "float": {
                        ((List)valuesToSet.get(key)).add(value);
                        break;
                    }
                    case "integer": {
                        ((List)valuesToSet.get(key)).add(value instanceof Double ? Long.valueOf(((Double)value).longValue()) : value);
                        break;
                    }
                    case "string": {
                        ((List)valuesToSet.get(key)).add(value.toString());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("TableStore contains wrong type: \"" + tableStore.getVariableType().get(key) + "\"");
                    }
                }
            });
        });
        mappings.forEach((key, value) -> this.setColumnValue(overwriteData, (Map<String, List<Object>>)valuesToSet, (String)key, (Variable)value));
    }

    private void validateMappings(Map<String, String> tableStoreVariableType, Map<String, Variable> mappings) {
        mappings.forEach((tableStoreKey, value) -> {
            String type = (String)tableStoreVariableType.get(tableStoreKey);
            if (type == null) {
                throw new IllegalArgumentException("TableStore does not contain key: " + tableStoreKey);
            }
            String variableTypeName = value.getType().name();
            if (!variableTypeName.startsWith(type)) {
                throw new IllegalArgumentException("Wrong variable " + value.getId() + " of type " + variableTypeName + " is mapped to TableStore's key: " + tableStoreKey);
            }
        });
    }

    private void setColumnValue(boolean overwriteData, Map<String, List<Object>> valuesToSet, String tableStoreKey, Variable variableToSet) {
        Object[] valueToSet = overwriteData || CommonUtils.isColumnEmpty((Object[])variableToSet.getValue()) ? this.castArrayToProperType(valuesToSet.get(tableStoreKey).toArray(), variableToSet.getType()) : ArrayUtils.addAll((Object[])((Object[])variableToSet.getValue()), (Object[])this.castArrayToProperType(valuesToSet.get(tableStoreKey).toArray(), variableToSet.getType()));
        variableToSet.setValue((Object)valueToSet);
    }

    private Object[] castArrayToProperType(Object[] array, Type<?> type) {
        Object[] properlyTypedArray = CommonUtils.createTableOfType(array.length, type);
        IntStream.range(0, array.length).forEach(i -> {
            properlyTypedArray[i] = array[i];
        });
        return properlyTypedArray;
    }

    private void handleTableMappingType(ActivityContextMap activityContextMap, TableStore tableStore, String activityDefId, String tableId, boolean overwriteData) throws IllegalStateException {
        FormGrid grid = this.getVariableSet(activityContextMap, activityDefId, tableId);
        boolean isTableStoreFitsInTableVariables = tableStore.getVariableType().entrySet().stream().allMatch(entry -> grid.getFields().stream().anyMatch(field -> field.getVariableId().equals(entry.getKey())));
        if (isTableStoreFitsInTableVariables) {
            if (overwriteData) {
                grid.getFields().forEach(field -> activityContextMap.getVariable(field.getVariableId()).setValue(activityContextMap.getVariable(field.getVariableId()).getType().defaultValue()));
            }
        } else {
            throw new IllegalArgumentException("Cannot map TableStore with keys \"" + Arrays.asList(tableStore.getKeys()) + "\" onto VariableSet \"" + tableId + "\"!");
        }
        HashMap<String, Object> valuesToSet = new HashMap<String, Object>();
        Arrays.asList(tableStore.getKeys()).forEach(id -> {
            switch (tableStore.getVariableType().get(id)) {
                case "date": {
                    this.handleDateValues(activityContextMap, (String)id, tableStore, (Map<String, Object>)valuesToSet);
                    break;
                }
                case "float": {
                    this.handleDoubleValues(activityContextMap, (String)id, tableStore, (Map<String, Object>)valuesToSet);
                    break;
                }
                case "integer": {
                    this.handleLongValues(activityContextMap, (String)id, tableStore, (Map<String, Object>)valuesToSet);
                    break;
                }
                case "string": {
                    this.handleStringValues(activityContextMap, (String)id, tableStore, (Map<String, Object>)valuesToSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TableStore contains wrong type: \"" + tableStore.getVariableType().get(id) + "\"");
                }
            }
        });
        valuesToSet.forEach((key, value) -> activityContextMap.getVariable(key).setValue(value));
    }

    private FormGrid getVariableSet(ActivityContextMap activityContextMap, String activityDefId, String tableId) {
        Activity tablesActivity = this.activityFinder.findByProcessId(activityContextMap.getProcessId(), new String[0]).stream().filter(activity -> activity.getActivityDefinitionId().equals(activityDefId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Activity with id: '" + activityDefId + "' not found in process!"));
        List formElements = this.formService.getForm(activityContextMap.getProcessId(), tablesActivity.getActivityId()).getElements();
        return TableStoreUtils.getTableById(formElements, tableId, activityDefId);
    }

    private void handleDateValues(ActivityContextMap activityContextMap, String id, TableStore tableStore, Map<String, Object> valuesToSet) {
        Object[] existingDateValues = (LocalDate[])activityContextMap.getVariable(id).getValue();
        Object[] tableStoreDateValues = (LocalDate[])tableStore.getData().stream().map(oneRecord -> {
            String dateAsString = (String)oneRecord.get(id);
            return dateAsString == null ? null : new LocalDate((Object)dateAsString);
        }).toArray(LocalDate[]::new);
        valuesToSet.put(id, ArrayUtils.addAll((Object[])existingDateValues, (Object[])tableStoreDateValues));
    }

    private void handleDoubleValues(ActivityContextMap activityContextMap, String id, TableStore tableStore, Map<String, Object> valuesToSet) {
        Object[] existingDoubleValues = (Double[])activityContextMap.getVariable(id).getValue();
        Object[] tableStoreDoubleValues = (Double[])tableStore.getData().stream().map(oneRecord -> (Double)oneRecord.get(id)).toArray(Double[]::new);
        valuesToSet.put(id, ArrayUtils.addAll((Object[])existingDoubleValues, (Object[])tableStoreDoubleValues));
    }

    private void handleLongValues(ActivityContextMap activityContextMap, String id, TableStore tableStore, Map<String, Object> valuesToSet) {
        Object[] existingLongValues = (Long[])activityContextMap.getVariable(id).getValue();
        Object[] tableStoreLongValues = (Long[])tableStore.getData().stream().map(oneRecord -> (Long)oneRecord.get(id)).toArray(Long[]::new);
        valuesToSet.put(id, ArrayUtils.addAll((Object[])existingLongValues, (Object[])tableStoreLongValues));
    }

    private void handleStringValues(ActivityContextMap activityContextMap, String id, TableStore tableStore, Map<String, Object> valuesToSet) {
        Object[] existingStringValues = (String[])activityContextMap.getVariable(id).getValue();
        Object[] tableStoreStringValues = (String[])tableStore.getData().stream().map(oneRecord -> (String)oneRecord.get(id)).toArray(String[]::new);
        valuesToSet.put(id, ArrayUtils.addAll((Object[])existingStringValues, (Object[])tableStoreStringValues));
    }
}

