/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.duals;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class SynchronizeIndexesDual {
    private static Logger log = Logger.getLogger(SynchronizeIndexesDual.class);
    @Autowired
    private CUFCommonDocumentService documentsService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("synchronize-indexes")).name("dual-app-set.synchronize-indexes.name")).description("dual-app-set.synchronize-indexes.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}synchronize-indexes-from-documents-application")).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("docClass").name("dual-app-set.synchronize-indexes.docClass.name").type((Type)Types.STRING).create()).parameter().id("indexes").name("dual-app-set.synchronize-indexes.indexes.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("variables").name("dual-app-set.synchronize-indexes.variables.name").type((Type)Types.VARIABLE_ARRAY).create();
    }

    public void execute(ApplicationContext context, @Param String docClass, @Param String[] indexes, @Param Variable[] variables) throws IllegalArgumentException {
        log.trace((Object)"*** Synchronize indexes application ***");
        this.synchronizeIndexes(context.getProcessId(), docClass, indexes, variables);
    }

    public void set(AcceptanceContext context, @Param String docClass, @Param String[] indexes, @Param Variable[] variables, Translator translator) throws IllegalArgumentException {
        log.trace((Object)"*** Synchronize indexes setter ***");
        this.synchronizeIndexes(context.getProcessId(), docClass, indexes, variables);
    }

    private void synchronizeIndexes(String processId, String docClass, String[] indexes, Variable[] variables) {
        Long docClassId = this.documentsService.getDocumentClassID(docClass);
        DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
        List allDocs = documentFinder.getDocumentsFromProcess(processId, new String[]{"documentClass"});
        log.debug((Object)("Znaleziono " + allDocs.size() + " dokument\u00f3w w zadaniu."));
        Collections.sort(allDocs, new DocComparator());
        for (WfDocument doc : allDocs) {
            if (!doc.getDocumentClassId().equals(docClassId)) continue;
            this.updateIndexes(doc, indexes, variables);
        }
    }

    private void updateIndexes(WfDocument doc, String[] indexes, Variable[] variables) {
        for (int i = 0; i < indexes.length; ++i) {
            IndexInfo index = doc.getIndexByName(indexes[i]);
            if (index != null) {
                if (index.getValue() == null || variables[i].getType() == Types.STRING && ((String)index.getValue()).equals("")) continue;
                Object value = DataConverter.convertObjectFromIndexType(index.getValue(), variables[i].getType());
                variables[i].setValue(value);
                continue;
            }
            log.debug((Object)("Nie znaleziono indexu " + indexes[i] + " w dokumencie o Id " + doc.getId()));
        }
    }

    public class DocComparator
    implements Comparator<WfDocument> {
        @Override
        public int compare(WfDocument o1, WfDocument o2) {
            return o1.getVersion().getVersion() - o2.getVersion().getVersion();
        }
    }
}

