PWE.integrationComponent.registerValidator('find-duplicates-validator', {
    apiVersion: 2,
    buildForm: function (form) {
        form.addField("confirmation");
        form.addField("variablesToCheck");
        form.setNotEmpty('variablesToCheck', true);
        form.addCombobox({
            id: "processesType",
            values: [{id: "ALL", display: CUFCommon.t('validator.processdoc.form.all')},
                {id: "OPENED", display: CUFCommon.t('validator.processdoc.form.opened')},
                {id: "CLOSED", display: CUFCommon.t('validator.processdoc.form.closed')}]
        });

        let excludingTable = form.addTable();
        excludingTable.addField("variablesExcludingDuplicates");
        excludingTable.addField("valuesExcludingDuplicates");

        form.addField("caseSensitive");
        form.addField("message");
        form.addCombobox({
            id: "duplicatePresentationComboBox",
            value: "BASIC",
            values: [
                {
                    id: "NONE",
                    display: CUFCommon.t('validator.processdoc.form.none.display'),
                    description: CUFCommon.t('validator.processdoc.form.none.desc')
                },
                {
                    id: "BASIC",
                    display: CUFCommon.t('validator.processdoc.form.basic.display'),
                    description: CUFCommon.t('validator.processdoc.form.basic.desc')
                },
                {
                    id: "EXTENDEND",
                    display: CUFCommon.t('validator.processdoc.form.extended.display'),
                    description: CUFCommon.t('validator.processdoc.form.extended.desc')
                }
            ],
            listeners: {
                change: function (value) {
                    if (value === 'NONE') {
                        form.hide('dataVariables');
                        form.resetArray('dataVariables');
                        form.hide('isHiddenColumn');
                        form.resetValue('isHiddenColumn');
                        form.hide('allowAcceptanceDespiteDuplicates');
                        form.resetValue('allowAcceptanceDespiteDuplicates');
                        form.setNotEmpty('allowAcceptanceDespiteDuplicates', false);
                        form.hide('save-data-field-set');
                        form.hide('saveDataToVariables');
                        form.resetValue('saveDataToVariables');
                        form.setValue('saveDataToVariables', false);
                        form.setNotEmpty('saveDataToVariables', false);
                        form.hide('custom-button-names-field-set');
                        form.resetValue('setDataButtonName');
                        form.hide('addColumnWithProcessName');
                        form.resetValue('addColumnWithProcessName');
                        form.hide('addLinkToDocuments');
                        form.resetValue('addLinkToDocuments');
                        form.hide('addLinkToProcess');
                        form.resetValue('addLinkToProcess');
                    } else {
                        form.show('dataVariables');
                        form.show('isHiddenColumn');
                        form.show('saveDataToVariables');
                        form.show('addColumnWithProcessName');
                        form.show('addLinkToDocuments');
                        form.show('addLinkToProcess');
                        form.setNotEmpty('saveDataToVariables', true);
                        form.setNotEmpty('allowAcceptanceDespiteDuplicates', true);
                        form.show('allowAcceptanceDespiteDuplicates', true);
                        form.show('save-data-field-set');
                        form.show('custom-button-names-field-set');
                    }
                }
            }
        });

        let dataTable = form.addTable();
        dataTable.addField("dataVariables");
        dataTable.addField('isHiddenColumn');

        let saveDataFieldSet = form.addFieldSet({
            id: "save-data-field-set",
            title: CUFCommon.t("action.find-duplicates-action.set-data-field-set")
        });

        saveDataFieldSet.addField({
            id: "saveDataToVariables",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show('variablesToGetData');
                        form.setNotEmpty('variablesToGetData', true);
                        form.show('variablesToSetData');
                        form.setNotEmpty('variablesToSetData', true);
                        form.show('setDataButtonName');
                        form.setNotEmpty('setDataButtonName', true);
                    } else {
                        form.hide('variablesToGetData');
                        form.resetValue('variablesToGetData');
                        form.setNotEmpty('variablesToGetData', false);
                        form.hide('variablesToSetData');
                        form.resetValue('variablesToSetData');
                        form.setNotEmpty('variablesToSetData', false);
                        form.hide('setDataButtonName');
                        form.resetValue('setDataButtonName');
                        form.setNotEmpty('setDataButtonName', false);
                    }
                }
            }
        });

        let setTable = saveDataFieldSet.addTable();
        setTable.addField({id: "variablesToGetData", hidden: true});
        setTable.addField({id: "variablesToSetData", hidden: true});
        saveDataFieldSet.addField({id: "setDataButtonName", hidden: true});

        if (saveDataFieldSet.getValue("saveDataToVariables")) {
            saveDataFieldSet.setNotEmpty('variablesToGetData', true);
            saveDataFieldSet.show('variablesToGetData');
            saveDataFieldSet.setNotEmpty('variablesToSetData', true);
            saveDataFieldSet.show('variablesToSetData');
            saveDataFieldSet.setNotEmpty('setDataButtonName', true);
            saveDataFieldSet.show('setDataButtonName');
        }

        form.addField("addColumnWithProcessName");
        form.addField("addLinkToDocuments");
        form.addField("addLinkToProcess");
        form.addField("allowAcceptanceDespiteDuplicates");

        let customNamingFieldSet = form.addFieldSet({
            id: "custom-button-names-field-set",
            title: CUFCommon.t("action.find-duplicates-action.custom-naming-field-set"),
            collapsible: true,
            collapsed: true
        });
        customNamingFieldSet.addField("customContinueButtonText");
        customNamingFieldSet.addField("customAcceptanceButtonText");

        if (form.getValue("duplicatePresentationComboBox") === 'NONE') {
            form.hide('dataVariables');
            form.hide('isHiddenColumn');
            form.hide('save-data-field-set');
            form.setNotEmpty('saveDataToVariables', false);
            form.hide('addColumnWithProcessName');
            form.hide('addLinkToDocuments');
            form.hide('addLinkToProcess');
            form.hide('allowAcceptanceDespiteDuplicates');
            form.setNotEmpty('allowAcceptanceDespiteDuplicates', false);
            form.hide('custom-button-names-field-set');
        } else {
            form.setNotEmpty('saveDataToVariables', true);
            form.setNotEmpty('allowAcceptanceDespiteDuplicates', true);
            form.show('dataVariables');
            form.show('isHiddenColumn');
            form.show('save-data-field-set');
            form.show('addColumnWithProcessName');
            form.show('addLinkToDocuments');
            form.show('addLinkToProcess');
        }
    }
});