PWE.integrationComponent.registerApplication('update-processes', {
    apiVersion: 2,
    buildForm: function (form) {
        addAppType(form);
        addProcessCombobox(form, this);
        form.addField("manyProcesses");
        form.addField({
            id: "includeClosedActivities",
            hidden: true,
            listeners: {
                change: (value) => (value) ? form.show("commentType") : form.hide("commentType")
            }
        });
        addCommentTypeCombobox(form);
        addActivityCombobox(form, this);
        addAcceptButton(form, this);
        form.addEmptyLine();
        addFilterTable(form, this);
        form.addEmptyLine();
        addUpdateVariables(form, this);
        addComment(form, this);
        afterLoad(form);
    }
});

function addCommentTypeCombobox(form) {
    form.addCombobox({
        id: "commentType",
        values: [
            {
                id: "SINGULAR", display: CUFCommon.t("update-processes.comment-type.singular")
            },
            {
                id: "COLLECTIVE", display: CUFCommon.t("update-processes.comment-type.collective")
            }
        ],
        hidden: !form.getValue("includeClosedActivities")
    });
}

function addAppType(form) {
    form.addCombobox({
        id: "appType",
        values: [
            {id: "ACCEPT_ACTIVITY", display: CUFCommon.t("update-processes.accept-activity")},
            {id: "CANCEL_PROCESS", display: CUFCommon.t("update-processes.cancel-process")},
            {id: "UPDATE_PROCESS", display: CUFCommon.t("update-processes.update-process")},
            {id: "UPDATE_ALL_ACTIVITIES_WITH_PROCESS", display: CUFCommon.t("update-processes.update-all-activities-with-process")}
        ],
        listeners: {
            change: function (value) {
                if (value === "ACCEPT_ACTIVITY") {
                    toggleFieldsWhenAppTypeEqualsAcceptActivity(form);
                } else if (value === "CANCEL_PROCESS") {
                    toggleFieldsWhenAppTypeEqualsCancelProcess(form);
                } else if (value === "UPDATE_ALL_ACTIVITIES_WITH_PROCESS") {
                    toggleFieldsWhenAppTypeEqualsUpdateAllActivitiesWithProcess(form);
                } else {
                    toggleFieldsWhenAppTypeIsEmptyOrSomethingDifferent(form);
                }
                updateTable.clear();
                filterTable.clear();
            }
        }
    });
}

function addProcessCombobox(form, scope) {
    var me = scope;
    CufComp.addComboboxProcessesTypes("processDefId", {
        change: function (value) {
            var activitiesUrl = "plugin/com.suncode-cuf-components/processes/activitiesTypes/";
            var variablesUrl = "plugin/com.suncode-cuf-components/processes/processVariables/";
            if (value) {
                form.enable("activityId");
                form.enable("updateTable");
                form.enable("filterTable");
            } else {
                form.disable("activityId");
                form.disable("updateTable");
                form.disable("filterTable");
            }
            form.resetValue("activityId");
            updateTable.clear();
            filterTable.clear();
            if (!form.hasVariableValue("processDefId") && !form.hasFunctionValue("processDefId")) {
                me.activityCombobox.setUrl(activitiesUrl + value);
                me.variablesToFilter.setUrl(variablesUrl + value);
                me.variablesToSet.setUrl(variablesUrl + value);
            }
        }
    }, form);
}

function addActivityCombobox(form, scope) {
    var me = scope;
    this.activityCombobox = CufComp.addComboboxActivitiesTypes("activityId", form.getValue("processDefId"), {
        change: function (value) {
            var url = "plugin/com.suncode-cuf-components/processes/activityButtons/";
            if (value) {
                form.enable("acceptButtonId");
                url = url + form.getValue("processDefId") + "/" + value;
            } else {
                form.disable("acceptButtonId");
            }
            form.resetValue("acceptButtonId");
            if (!form.hasVariableValue("activityId") && !form.hasFunctionValue("activityId")) {
                me.acceptButtonCombobox.setUrl(url);
            }
        }
    }, form);
}

function addAcceptButton(form, scope) {
    scope.acceptButtonCombobox = CufComp.addComboboxAcceptButtons("acceptButtonId", form.getValue("activityId"), form.getValue("processDefId"), null, form);
}

function addFilterTable(form, scope) {
    var me = scope;
    me.filterTable = form.addTable({
        id: "filterTable",
        name: CUFCommon.t("update-processes.filter-table")
    });
    me.variablesToFilter = CufComp.addComboboxProcessVariables("variablesToFilter", form.getValue("processDefId"), null, me.filterTable, false);
    me.filterTable.addField({
        id: "valuesToFilter",
        optional: false
    });
}

function addUpdateVariables(form, scope) {
    var me = scope;
    form.addField({
        id: "updateVariables",
        listeners: {
            change: function (value) {
                if (value) {
                    form.show("updateTable");
                    me.variablesToFilter.setUrl("plugin/com.suncode-cuf-components/processes/processVariables/" + form.getValue("processDefId"));
                    me.variablesToSet.setUrl("plugin/com.suncode-cuf-components/processes/processVariables/" + form.getValue("processDefId"));
                } else {
                    me.updateTable.clear();
                    form.hide("updateTable");
                }
            }
        }
    });

    me.updateTable = form.addTable({
        id: "updateTable",
        name: CUFCommon.t("update-processes.update-table"),
        hidden: true
    });

    me.variablesToSet = CufComp.addComboboxProcessVariables("variablesToSet", form.getValue("processDefId"), null, me.updateTable, false);
    me.updateTable.addField({
        id: "valuesToSet",
        optional: false
    });
}

function addComment(form, scope) {
    form.addField({
        id: "addComment",
        listeners: {
            change: function (value) {
                if (value) {
                    form.show("commentValue");
                } else {
                    form.resetValue("commentValue");
                    form.hide("commentValue");
                }
            }
        }
    });
    form.addField("commentValue");
}

function afterLoad(form) {
    if (!form.getValue("processDefId")) {
        form.disable("activityId");
    }
    if (!form.getValue("processDefId")) {
        form.disable("activityId");
        form.disable("updateTable");
        form.disable("filterTable");
    }
    if (form.getValue("appType") !== "ACCEPT_ACTIVITY") {
        form.hide("acceptButtonId");
    }
    if (!form.getValue("activityId")) {
        form.disable("acceptButtonId");
    }
    if (form.getValue("updateVariables") || form.getValue("appType") === "UPDATE_PROCESS") {
        form.show("updateTable");
        form.show("includeClosedActivities");
    }
    if (!form.getValue("addComment")) {
        form.hide("commentValue");
    }

    if (form.getValue("appType") === "UPDATE_ALL_ACTIVITIES_WITH_PROCESS") {
        form.hide("activityId");
        form.hide("updateVariables");
        form.show("updateTable");
        form.show("includeClosedActivities");
    }
}

function toggleFieldsWhenAppTypeEqualsAcceptActivity(form) {
    form.show("updateVariables");
    form.show("acceptButtonId");
    form.setValue("updateVariables", false);
    form.setNotEmpty("activityId", true)
    form.show("activityId");
    form.hide("includeClosedActivities");
}

function toggleFieldsWhenAppTypeEqualsCancelProcess(form) {
    form.show("updateVariables");
    form.hide("acceptButtonId");
    form.resetValue("acceptButtonId");
    form.setValue("updateVariables", false);
    form.setNotEmpty("activityId", true)
    form.show("activityId");
    form.hide("includeClosedActivities");
}

function toggleFieldsWhenAppTypeEqualsUpdateAllActivitiesWithProcess(form) {
    form.hide("updateVariables");
    form.hide("acceptButtonId");
    form.resetValue("acceptButtonId");
    form.show("updateTable");
    form.setNotEmpty("activityId", false)
    form.hide("activityId");
    form.show("includeClosedActivities");
}

function toggleFieldsWhenAppTypeIsEmptyOrSomethingDifferent(form) {
    form.hide("updateVariables");
    form.hide("acceptButtonId");
    form.resetValue("acceptButtonId");
    form.show("updateTable");
    form.setNotEmpty("activityId", true)
    form.show("activityId");
    form.show("includeClosedActivities");
}