PWE.integrationComponent.registerApplication('uniqueness-app', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField("variables");
        form.addField("targetVariable");
        var exclusionVariableValueTable = form.addTable();
        exclusionVariableValueTable.addField("exclusionVariables");
        exclusionVariableValueTable.addField("exclusionValues");
        form.addField("trueValue");
        form.addField("falseValue");
        form.addField({
            id: "commentError",
            hidden: true
        });
        if (form.getValue("commentError")) {
            form.show("commentError");
        }
    },
    validateForm: function (api) {
        var exclusionVariablesLength = api.getArraySize("exclusionVariables");
        try {
            for (var i = 0; i < exclusionVariablesLength; i++) {
                if (!api.hasFunctionValue("exclusionValues", i)) {
                    switch (api.getVariableType("exclusionVariables")[i]) {
                        case "integer":
                            if (isNaN(Number(api.getValue("exclusionValues")[i])) || api.getValue("exclusionValues")[i] % 1 !== 0) {
                                api.markError("exclusionValues", i);
                                throw new Error("Given value must be an integer type");
                            }
                            break;
                        case "date":
                            var dateRegex = /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/g;
                            if (!(api.getValue("exclusionValues")[i]).match(dateRegex)) {
                                api.markError("exclusionValues", i);
                                throw new Error("Given value must be a date type");
                            }
                            break;
                        case "datetime":
                            var dateTimeRegex = /^\d\d\d\d-(0?[1-9]|1[0-2])-(0?[1-9]|[12][0-9]|3[01]) (00|[0-9]|1[0-9]|2[0-3]):([0-9]|[0-5][0-9]):([0-9]|[0-5][0-9])$/g;
                            if (!(api.getValue("exclusionValues")[i]).match(dateTimeRegex)) {
                                api.markError("exclusionValues", i);
                                throw new Error("Given value must be a datetime type");
                            }
                            break;
                        case "float":
                            if (isNaN(Number(api.getValue("exclusionValues")[i].replace(",", ".")))) {
                                api.markError("exclusionValues", i);
                                throw new Error("Given value must be a float type");
                            }
                            break;
                        case "boolean":
                            if (!(api.getValue("exclusionValues")[i] == "true") && !(api.getValue("exclusionValues")[i] == "false")) {
                                api.markError("exclusionValues", i);
                                throw new Error("Given value must be a boolean type");
                            }
                            break;
                    }
                }
            }
        } catch (e) {
            console.error(e);
            api.showErrorMessage(CUFCommon.t("uniqueness-app.wrong-variable-type.error-message"));
            return false;
        }
    }
});