PWE.integrationComponent.registerApplication('table-store-set-items-dual', {
    apiVersion: 2,
    buildForm: build,
    validateForm: validate
});

PWE.integrationComponent.registerVariablesSetter('table-store-set-items-dual', {
    apiVersion: 2,
    buildForm: build,
    validateForm: validate
});

function build(form) {
    form.addField("tableStoreParam");
    var table = form.addTable({
        id: 'fields',
        notEmpty: true
    });
    table.addField("fieldIds");
    table.addField("values");
    form.addField("condition");
}

function validate(api) {
    if (api.getVariableType("tableStoreParam") !== "string") {
        api.markError("tableStoreParam");
        api.showErrorMessage(CUFCommon.t("form-valid-string"));
        return false;
    }
    var fieldsLength = api.getArraySize("fieldIds");
    var wrongFunctionReturnType = false;
    for (var i = 0; i < fieldsLength; i++) {
        if (api.getFunctionReturnType("values", i) !== "string") {
            api.markError("values", i);
            wrongFunctionReturnType = true;
        }
    }
    if (wrongFunctionReturnType) {
        api.showErrorMessage(CUFCommon.t("form-valid-function-string"));
        return false;
    }
    if (api.getFunctionReturnType("condition") !== "boolean" && api.getFunctionReturnType("condition") != undefined) {
        api.markError("condition");
        api.showErrorMessage(CUFCommon.t("form-valid-function-boolean"));
        return false;
    }
    return true;
}