/**
 * Synchronize indexes from documents with form variables
 */
PWE.integrationComponent.registerApplication( 'synchronize-indexes', {
    apiVersion: 2,
    buildForm: function( form , options ){
        buildSynchronizeIndexesForm(form, this);
    } 
});

PWE.integrationComponent.registerVariablesSetter(  'synchronize-indexes', {
    apiVersion: 2,
    buildForm: function( form , options ){
        buildSynchronizeIndexesForm(form, this);
    }
});

function buildSynchronizeIndexesForm(form, scope){
    var me = scope;
    CufComp.addComboboxClassList("docClass", {
        change: function (value) {
            if (!form.hasVariableValue("docClass") && !form.hasFunctionValue("docClass")) {
                me.indexTable.clear();
                me.indexes.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
            }
        }
    }, form);
    form.addButton({
       text: CUFCommon.t("synchronize-indexes.fill-indexes"),
       handler: function(){
           me.indexTable.clear();
           fillIndexes(form, me, form.getValue("docClass"));
       }
    });
    me.indexTable = form.addTable({tableId: "index-table"});
    this.indexes = CufComp.addComboboxClassIndexList("indexes", form.getValue("docClass"), null, indexTable);
    indexTable.addField("variables");
    
};

function fillIndexes(form, scope, docClass){
    var me = scope;
    jQuery.ajax({
        type : "GET",
        data : {
            query : "",
            start : 0,
            limit : 1000
        },
        url : PlusWorkflow.getAbsolutePath("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + docClass),
        error :  function(jqXHR, textStatus, errorThrown) {
            Logger.error(errorThrown);
        },
        async : true,
        contentType: "application/json; charset=utf-8",
        dataType: "json"
    })
    .done(function(data) {
        var size = form.getArraySize("indexes");
        for (var i = 0; i < data.data.length; i++){
            me.indexTable.addRow([
                {id:"variables", value: data.data[i]["name"].toLowerCase().split(' ').join('_')},
                {id:"indexes", value: data.data[i]["name"]}
            ]);
        }
    });
}