/**
 * PWE form of ShowAndAttachDocumentsFromArchive.
 */
PWE.integrationComponent.registerFormAction( 'show-and-attach-document-from-archive', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        var me = this;
        CufComp.addComboboxClassList("document-class-id", {
            change: function (value) {
                if ((!form.hasVariableValue("document-class-id") && !form.hasFunctionValue("document-class-id"))) {
                    me.sortByColumn.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                    me.displayedIndexes.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                    if (form.getValue("search-criteria-on")) {
                        me.indexes.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                    }
                }
            }
        }, form);

        form.addField({
            id: "search-criteria-on",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("index-table");
                        form.show("force-exact-search");
                    } else {
                        form.hide("index-table");
                        form.hide("force-exact-search");
                    }
                }
            }
        });
        var indexTable = form.addTable({id: "index-table", hidden: !form.getValue("search-criteria-on") });
        this.indexes = CufComp.addComboboxClassIndexList("indexes-id", form.getValue("document-class-id"), null, indexTable);
        indexTable.addField("indexes-value");
        CufComp.setClassNameById(form, "document-class-id");
        CufComp.setClassIndexesById(form, "document-class-id", "indexes-id");
        buildSortingFieldSet(form);
        this.displayedIndexes = CufComp.addComboboxClassIndexList("displayedIndexes", form.getValue("document-class-id"), null, form);
        CufComp.setClassIndexesById(form, "document-class-id", "displayedIndexes");
        form.addField({id: "force-exact-search", hidden: !form.getValue("search-criteria-on")});
    }
});

function buildSortingFieldSet(form){
    let sortingFieldSet = form.addFieldSet({
        id: "sorting-fs",
        collapsible: true,
        collapsed: false,
        title: CUFCommon.t("cuf-components.show-and-attach-document-from-archive.sorting-field-set")
    });
    this.sortByColumn = CufComp.addComboboxClassIndexList("sortBy", form.getValue("document-class-id"), null, sortingFieldSet);
    sortingFieldSet.addCombobox({
        id: 'sortDirection',
        values: [
            {id: 'ASC', display: CUFCommon.t('show-and-attach-document-from-archive.sort-direction.asc')},
            {id: 'DESC', display: CUFCommon.t('show-and-attach-document-from-archive.sort-direction.desc')}
        ]
    });
}


