/**
 * Dynamic form for show-alert.
 */

PWE.integrationComponent.registerFormAction( 'show-alert', {
    
    buildForm: function( form ) {
        form.addCombobox({
            id : "alertType",
            values : [{id : "standard", display : CUFCommon.t("show-alert.alert-type.standard")},
                      {id : "success", display : CUFCommon.t("show-alert.alert-type.success")},
                      {id : "failure", display : CUFCommon.t("show-alert.alert-type.failure")},
                      {id : "confirmation", display : CUFCommon.t("show-alert.alert-type.confirmation")}],
            onChange: function(value) {
                if(value == "confirmation") {
                    form.showField("title");
                    form.hideField("hideAfter");
                }
                else {
                    form.hideField("title");
                    form.showField("hideAfter");
                }
            }
        });
        if ( form.getFieldValue("alertType" ) == "confirmation"){
        	form.addField({
            	id : "title"
    		});
        }
        else{
        	form.addField({
            	id : "title",
    			hidden : true
    		});
        }
        form.addField("message");
        form.addField("hideAfter");
    }
});