/**
 * 
 */

PWE.integrationComponent.registerApplication( 'set-row-dual', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        let singleColumnFieldSet = form.addFieldSet({
            id: "single-column-fieldset",
            title: CUFCommon.t("single-column-fieldset.title")
        });
        singleColumnFieldSet.addField("column");
        singleColumnFieldSet.addField("value");

        let multiColumnFieldSet = form.addFieldSet({
            id: "multi-column-fieldset",
            title: CUFCommon.t("multi-column-fieldset.title"),
            collapsible: true
        });

        let table = multiColumnFieldSet.addTable("multi-column-table");
    	table.addField("columns");
        table.addField("values");

    	form.addField({
        	id: "condition"
        });
    	form.addField({
            id: "commentError",
            hidden: true
        });
        if(form.getValue("commentError")){
            form.show("commentError");
        }
    },
    
    validateForm: function(api){
        return validate(api);
    }
});

PWE.integrationComponent.registerVariablesSetter( 'set-row-dual', {
	apiVersion: 2,
	buildForm: function( form , options ) {
        let singleColumnFieldSet = form.addFieldSet({
            id: "single-column-fieldset",
            title: CUFCommon.t("single-column-fieldset.title")
        });
        singleColumnFieldSet.addField("column");
        singleColumnFieldSet.addField("value");

        let multiColumnFieldSet = form.addFieldSet({
            id: "multi-column-fieldset",
            title: CUFCommon.t("multi-column-fieldset.title"),
            collapsible: true
        });

        let table = multiColumnFieldSet.addTable("multi-column-table");
        table.addField("columns");
        table.addField("values");

    	form.addField({
        	id: "condition"
        });
    },
    
    validateForm: function(api){
        return validate(api);
    }
});

function validate(api){
    if (api.getVariableType("column") != (api.getFunctionReturnType("value") + "[]")){
    	api.markError("column");
    	api.showErrorMessage(CUFCommon.t("default.incompatible-variable-function-types"));
    	return false;
    }
    if (api.getValue("condition") != "" && api.getFunctionReturnType("condition") != "boolean"){
        api.markError("condition");
        api.showErrorMessage(CUFCommon.t("default.wrong-function-type.boolean"));
        return false;
    }
}