PWE.integrationComponent.registerFormAction('exchange-rate-table-action', {
	apiVersion: 2,
	buildForm: function (form, options) {
		form.addField("currency");
		form.addField("date");
		form.addField("dateOffset");
		form.addField('effectiveDate');
		form.addField("exchangerate");
		form.addField("tableNo");
		form.addField("tableName");
		form.addField("condition");
		if (options.destination === "BUTTON"){
			form.addField("dynamicTableId");
			form.setNotEmpty("dynamicTableId", true);
		}
	},
	validateForm: function (api) {
		if (api.hasFunctionValue('condition') && 'boolean' !== api.getFunctionReturnType('condition')) {
			api.markError('condition')
			api.showErrorMessage(CUFCommon.t('form-valid-function-boolean'));
			return false;
		}
	
		if (api.getVariableType('date')!=='date[]') {
			api.showErrorMessage(CUFCommon.t('form-valid-date-array'));
			api.markError('date')
			return false;
		}
		if (api.getVariableType('exchangerate')!=='float[]') {
			api.showErrorMessage(CUFCommon.t('form-valid-float-array'));
			api.markError('exchangerate')
			return false;
		}
		if (api.getVariableType('currency')!=='string[]') {
			api.markError('currency')
			api.showErrorMessage(CUFCommon.t('form-valid-string-array'));
			return false;
		}
		if (api.getValue('tableNo') !== '' && api.getVariableType('tableNo')!=='string[]') {
			api.markError('tableNo')
			api.showErrorMessage(CUFCommon.t('form-valid-string-array'));
			return false;
		}
		if (api.getValue('tableName') !== '' && api.getVariableType('tableName')!=='string[]') {
			api.markError('tableName')
			api.showErrorMessage(CUFCommon.t('form-valid-string-array'));
			return false;
		}
		if (api.getValue("effectiveDate") !== "" && api.getVariableType("effectiveDate") !== "date[]") {
			api.markError("effectiveDate");
			api.showErrorMessage(CUFCommon.t('form-valid-date-array'));
			return false;
		}
		return true;
	}
});