PWE.integrationComponent.registerApplication('cuf-components.pdf.splitter.dual', {
    apiVersion: 2,
    buildForm: function (form, options) {
        buildDynamicFrom(form, options)
    },

    validateForm: function (api) {
        return validate(api);
    }
});

PWE.integrationComponent.registerVariablesSetter('cuf-components.pdf.splitter.dual', {
    apiVersion: 2,
    buildForm: function (form, options) {
        buildDynamicFrom(form, options)
    },

    validateForm: function (api) {
        return validate(api);
    }
});

function buildDynamicFrom(form, options) {
    const me = this;
    form.addField("fileId");
    CufComp.addComboboxClassList("documentClassName", {
        change: function (value) {
            if (!form.hasVariableValue("documentClassName") && !form.hasFunctionValue("documentClassName")) {
                me.indexNameCombobox.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
            }
            me.indexTable.clear();
        }
    }, form);
    form.addField("documentDescription");
    form.addField("saveAsNewVersion");
    form.addField("executeActions");
    form.addField("attachToProcess");

    this.pageRange = form.addTable({
        name: CUFCommon.t("dpwe.label.page-range")
    });
    this.pageRange.addField("fromPages");
    this.pageRange.addField("toPages");

    this.indexTable = form.addTable({
        name: CUFCommon.t("dpwe.label.indexes")
    });
    this.indexNameCombobox = CufComp.addComboboxClassIndexList("indexesName", form.getValue("documentClassName"), null, this.indexTable);
    this.indexTable.addField("indexesValue");

}

function validate(api) {
    var error = false;
    var fromPages = api.getValue("fromPages", false);
    var toPages = api.getValue("toPages", false);

    for (var index = 0; index < fromPages.length; index++) {
        if (isValue("fromPages", index, api) && fromPages[index] < 1) {
            error = true;
            api.markError('fromPages',index);
        }
        if (isValue("fromPages", index, api) && isValue("toPages", index, api) && fromPages[index] > toPages[index]) {
            error = true
            api.markError('fromPages',index);
            api.markError('toPages',index);
        }
    }
    if(error){
        api.showErrorMessage(CUFCommon.t('form-pdf-valid-page-range'));
    }
    return !error;
}

function isValue(id,index, api){
    return !api.hasVariableValue(id,index) && !api.hasFunctionValue(id,index);
}