PWE.integrationComponent.registerFormAction('paint-rows', {
	apiVersion: 2,
    buildForm: function (form, options) {
        form.addField("condition");
        form.addField({
            id: "useSystemThemeFontColor",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("color");
                    } else {
                        form.show("color");
                    }
                }
            }
        });
        form.addColorPicker("color");
        var resolvedColor = resolveColor(form.getValue("color"));
        form.setValue("color", resolvedColor);
        form.addField({
            id: "useSystemThemeBackgroundColor",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.hide("colorBG");
                    } else {
                        form.show("colorBG");
                    }
                }
            }
        });
        form.addColorPicker("colorBG");
        form.addField("columns");
        if (form.getValue("useSystemThemeFontColor")) {
            form.hide("color");
        }
        if (form.getValue("useSystemThemeBackgroundColor")) {
            form.hide("colorBG");
        }
    },
    
    validateForm: function(api){
    	return CufCmpValidator.checkIfLogicalFunction(api, "condition");
    }
});
function resolveColor(color) {
	//kompatybilność wstecz
	if (color && (color.indexOf('#')<0)) {
    	color = "#" + color;
    } 
    return color;
}