/**
 * Form of manage-documents action
 */

PWE.integrationComponent.registerFormAction('manage-documents', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField("checkRights");
        form.addCombobox({
            id: "documentActions",
            values: [
                { id: "attach", display: CUFCommon.t("manage-documents.attach") },
                { id: "detach", display: CUFCommon.t("manage-documents.detach") },
                { id: "show", display: CUFCommon.t("manage-documents.show") },
                { id: "changeDescription", display: CUFCommon.t("manage-documents.change-description") },
                { id: "delete", display: CUFCommon.t("manage-documents.delete") }
            ]
        });
        form.addField({
            id: "showAdvancedConfig",
            listeners: {
                change: function (value) {
                    if (value) {
                        addAdvancedFields(form);
                    } else {
                        removeAdvancedFields(form);
                    }
                }
            }
        });

        if (form.getValue("showAdvancedConfig") == true) {
            addAdvancedFields(form);
        }

        function addAdvancedFields(form) {
            form.addField("showIndexes");
            form.addField("autoSelectFirst");
            CufComp.addComboboxClassList("documentClassNameList", null, form);
            form.addField({
                id: "callback"
            });
            
            // przestarzale ukryte parametry
            form.addField({
                id: "documentClassIdList",
                hidden: true,
                value: []
            });
            form.addField({
                id: "refreshAfterAdd",
                hidden: true
            });
        };

        function removeAdvancedFields(form) {
            form.removeField("showIndexes");
            form.removeField("autoSelectFirst");
            form.removeField("documentClassIdList");
            form.removeField("documentClassNameList");
            form.removeField("refreshAfterAdd");
            form.removeField("callback");
        };
    }
});
