PWE.integrationComponent.registerSystemFunction('isActivityState', [
	{
		type : 'string',
		id : 'processId',
		array : false
	},
	{
		type : 'string',
		id : 'activityId',
		array : false
	},
	{
		type : 'string',
		id : 'state',
		array : true
}],
{
	apiVersion : 2,
	buildForm : function( form, options ) {
		form.addField( 'processId' );
		form.addField( 'activityId' );
		form.addCombobox({
			id: 'state',
			remote: {
				url: "plugin/com.suncode-cuf-components/ActivityController/activityStateList",
				fields: [
					{
						name: "activityStateName",
						type: "string"
					},
					{
						name: "activityState",
						type: "string"
					},
					{
						name: "activityStateNumber",
						type: "integer"
					}
				]
			},
			template: [
				{
					label: CUFCommon.t("dpwe-activity-state.name"),
					field: "activityState"
				}
			],
			valueField: "activityState",
			displayField: "activityState",
			sort: [{
				property: "activityState",
				direction: "ASC"
			}],
			listeners: null,
			forceSelection: false
		});
	}
});