PWE.integrationComponent.registerFormAction('export-to-excel', {
    apiVersion: 2,
    buildForm: function (form, options) {
        var table = form.addTable({
            tableId: "excelTable"
        });
        table.addField("columns");
        table.addCombobox({
            id: "filterTypes",
            values: [
                { id: "==", display: "==" },
                { id: "!=", display: "!=" },
                { id: "<", display: "<" },
                { id: ">", display: ">" },
                { id: "<=", display: "<=" },
                { id: ">=", display: ">=" },
                { id: "regexp", display: "regexp" }
            ]
        });
        table.addField("filterValues");
        if (options.destination == "VARIABLESET"){
        	form.addField("buttonName");
        }
        form.addField("fileName");
        form.addCombobox({
            id: "exportColumnTypes",
            values: [
                { id: "CUSTOM", display: CUFCommon.t("export-to-excel.custom") },
                { id: "ALL", display: CUFCommon.t("export-to-excel.all") },
                { id: "VISIBLE", display: CUFCommon.t("export-to-excel.visible") }
            ],
            listeners: {
                change: function (value) {
                    if (value == 'CUSTOM') {
                        form.show("columnsToExport");
                        form.setNotEmpty("columnsToExport", true);
                    }
                    else {
                        form.resetArray("columnsToExport");
                        form.hide("columnsToExport");
                        form.setNotEmpty("columnsToExport", false);
                    }
                }
            },
            notEmpty: true
        });
        form.addField("columnsToExport");
        if (form.getValue("exportColumnTypes") != "CUSTOM"){
            form.hide("columnsToExport");
        }
        if (form.getValue("columnsToExport") && form.getValue("columnsToExport").length > 0){
            form.show("columnsToExport");
            if (form.getValue("exportColumnTypes") != "CUSTOM"){
                form.setValue("exportColumnTypes", "CUSTOM");
            }
        }
    }
});