window.CufComp = {

    setDocumentDataObtainedFromServlet: function (object, form, url) {
        var cfg = new Object();
        if (Object.prototype.toString.call(object) === '[object String]') {
            cfg.id = object;
        } else {
            cfg = object;
        }
        var formComboValues = this.formComboValues,
            position = form.getFieldPosition(cfg.id);
        jQuery.ajax({
            type: "GET",
            url: url,
            async: true
        })
            .done(function (data) {
                form.removeField(cfg.id);
                cfg.values = formComboValues(data);
                form.addCombobox(cfg, position);
            })
            .fail(function () {
                Logger.error("Request error.");
            });
    },

    obtainDocClassNamesForCombobox: function (id, form) {
        this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("docs/classNames/"));
    },

    obtainDocClassIdsForCombobox: function (id, form) {
        this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("docs/classIds/"));
    },
    
    obtainClassIndexesForCombobox: function (id, form, className) {
        this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("docs/classIndexes/" + className));
    },

    obtainDocClassIdsAndNamesForCombobox: function (id, form) {
        this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("docs/classIdsAndNames/"));
    },
    obtainDocClassIndexesIdsAndNamesForCombobox: function (id, form, param) {
        if (param) {
            this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("docs/classIndexesIdsAndNames/" + param));
        } else {
            Logger.error("No param set.")
        }
    },
    obtainDocControllerEndPointCombobox: function (id, form, endpoint) {
        if (endpoint) {
            this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl(endpoint));
        } else {
            Logger.error("No End Point")
        }
    },
    obtainDataBaseAliases: function (id, form) {
        this.setDocumentDataObtainedFromServlet(id, form, this.prepareUrl("actions/db-aliases-names/"));
    },
    formComboValues: function (values) {
        var comboValues = [];
        if (values instanceof Array) {
            for (var i = 0; i < values.length; i++) {
                comboValues.push({
                    id: values[i],
                    display: values[i]
                });
            }
        } else {
            for (var key in values) {
                if (values.hasOwnProperty(key)) {
                    comboValues.push({
                        id: key,
                        display: values[key]
                    });
                }
            }
        }
        return comboValues;
    },

    prepareUrl: function (endpoint) {
        var url = PlusWorkflow.getAbsolutePath("/plugin/com.suncode-cuf-components/" + endpoint);
        return url;
    },
    //dla api v2
    addComboboxClassList: function (idName, listenersFn, form,position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/docs/docClassList",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "displayName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-doc-class.name"),
                    field: "displayName"
                }
            ],
            valueField: "name",
            displayField: "displayName",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false
        },position); 
    },
    
    addComboboxClassIdList: function (idName, listenersFn, form,position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/docs/docClassList",
                fields: [
                    {
                        name: "displayName",
                        type: "string"
                    },
                    {
                        name: "id",
                        type: "integer"
                    }
                ]
            },
            template: [
                {
                    label: "Id",
                    field: "id"
                },
                {
                    label: CUFCommon.t("dpwe-doc-class.name"),
                    field: "displayName"
                }
            ],
            valueField: "id",
            displayField: "id",
            sort: [{
                property: "id",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false
        },position); 
    },
    
    addComboboxClassIndexList: function (idName, className, listenersFn, form,position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/docs/docClassIndexList/" + className,
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "displayName",
                        type: "string"
                    },
                    {
                        name: "type",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-doc-class-index.name"),
                    field: "displayName"
                },
                {
                    label: CUFCommon.t("dpwe-doc-class-index.type"),
                    field: "type"
                }
            ],
            valueField: "name",
            displayField: "displayName",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false
        },position);
    },

    addOptionalComboboxClassIndexList: function(idName, className, listenersFn, form, optional, position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/docs/docClassIndexList/" + className,
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "displayName",
                        type: "string"
                    },
                    {
                        name: "type",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-doc-class-index.name"),
                    field: "displayName"
                },
                {
                    label: CUFCommon.t("dpwe-doc-class-index.type"),
                    field: "type"
                }
            ],
            valueField: "name",
            displayField: "displayName",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false,
            optional: optional
        },position);
    },
    
    addComboboxProcessesTypes: function (idName, listenersFn, form, position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/processTypes",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "processDefId",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("default.process-name"),
                    field: "name"
                }
            ],
            valueField: "processDefId",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false
        },position); 
    },
    
    addComboboxActivitiesTypes: function (idName, processDefId, listenersFn, form,position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/activitiesTypes/" + processDefId,
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "activityDefId",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("default.activity-name"),
                    field: "name"
                }
            ],
            valueField: "activityDefId",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false
        },position);
    },
    
    addComboboxAcceptButtons: function (idName, activityDefId, processDefId, listenersFn, form,position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/activityButtons/" + processDefId + "/" + activityDefId,
                fields: [
                    {
                        name: "buttonName",
                        type: "string"
                    },
                    {
                        name: "actionName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-accept-button.name"),
                    field: "buttonName"
                }
            ],
            valueField: "actionName",
            displayField: "buttonName",
            sort: [{
                property: "buttonName",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false
        },position);
    },
    
    addComboboxProcessVariables: function (idName, processDefId, listenersFn, form, optional, position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/processes/processVariables/" + processDefId,
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "id",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-variable.name"),
                    field: "name"
                }
            ],
            valueField: "id",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn,
            forceSelection: false,
            optional: optional
        },position);
    },
    
    addComboboxAllUsers: function (form,idName, position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/user/users",
                fields: [
                    {
                        name: "userName",
                        type: "string"
                    },
                    {
                        name: "fullName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-username.name"),
                    field: "userName"
                },
                {
                    label: CUFCommon.t("dpwe-fullname.name"),
                    field: "fullName"
                }
            ],
            valueField: "userName",
            displayField: "userName",
            sort: [{
                property: "userName",
                direction: "ASC"
            }],
            forceSelection: false
        },position);
    },
    
    addComboboxAllGroups: function (form, idName, position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/user/groups",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "displayName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-groups.name"),
                    field: "displayName"
                }
            ],
            valueField: "name",
            displayField: "displayName",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            forceSelection: false
        },position);
    },
    
    addComboboxAllOus: function (form, idName, position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/user/ous",
                fields: [
                    {
                        name: "symbol",
                        type: "string"
                    },
                    {
                        name: "displayName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-ous.name"),
                    field: "displayName"
                }
            ],
            valueField: "symbol",
            displayField: "displayName",
            sort: [{
                property: "symbol",
                direction: "ASC"
            }],
            forceSelection: false
        },position);
    },
    
    addComboboxAllRoles: function (form, idName, position) {
        return form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode-cuf-components/user/roles",
                fields: [
                    {
                        name: "specialId",
                        type: "string"
                    },
                    {
                        name: "displayName",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: CUFCommon.t("dpwe-roles.name"),
                    field: "displayName"
                }
            ],
            valueField: "specialId",
            displayField: "displayName",
            sort: [{
                property: "specialId",
                direction: "ASC"
            }],
            forceSelection: false
        },position);
    },
    
    resetColumnValue: function (id, form) {
        arraySize = form.getArraySize(id);
        for (pos = 0; pos < arraySize; pos++) {
            form.setFieldValueInArray(id, pos, "");
        }
    },
    
    setClassNameById : function(form, fieldId){
    	var classId=form.getValue(fieldId);
        if (!classId ||!this.isNumber(classId)){
            return;
        }
        var me = this;
        jQuery.ajax({
            type : "GET",
            url : me.prepareUrl("docs/classNameFromId/" + classId),
            error :  function(jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            }, 
            async : true
        })
        .done(function (data) {
            form.setValue(fieldId, data);
        })
    },
    
    setClassIndexesById : function(form, classFieldId, indexFieldId){
        
        var indexArr = form.getValue(indexFieldId);
        if (!indexArr.some(this.isNumber)) {
            return;
        }
        var me = this;
        jQuery.ajax({
            type : "GET",
            url : me.prepareUrl("docs/indexesNamesFromIds/"),
            data : {
                className : form.getValue(classFieldId),
                indexesIds : indexArr
            },
            error :  function(jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            }, 
            async : true
        })
        .done(function (data) {
            form.setValue(indexFieldId, data);
        })
    },
    
    isNumber : function(element, index, array){
        return !isNaN(element);
    },
    
    isNotEmptyValidation : function(api, id){
        if (!api.getValue(id)){
            api.markError(id);
            api.showErrorMessage(CUFCommon.t("default.validation.empty-parameter"));
            return false;
        }
        return true;
    },
    
    addComboboxLoggingLevels : function(form, idName) {
        return form.addCombobox({
            id: idName,
            values: [
                {id: "TRACE", display : 'Trace'},
                {id: "DEBUG", display : 'Debug'},
                {id: "INFO", display : 'Info'},
                {id: "WARN", display : 'Warn'},
				{id: "ERROR", display : 'Error'}
			]
        });
    },
    
    addComboboxJsonDataTypes : function(idName, form, position){
    	form.addCombobox({
			id: idName,
			remote: {
				url: "plugin/com.suncode-cuf-components/json/datatypes",
				fields: [
	                {
	                    name: "name",
	                    type: "string"
	                },
					{
						name: "displayName",
						type: "String"					
					}
				]
			},
			template: [
				{
					label: CUFCommon.t("json-function.datatype"),
					field: "displayName"
				}
			],
			valueField: "name",
			displayField: "displayName",
			sort: [{
				property: "displayName",
				direction: "ASC"
			}],
		}, position)
    }
    
};

window.CufCmpValidator = {
	checkIfLogicalFunction : function(api, parameterWithFunctionId){
		if (api.getFunctionReturnType(parameterWithFunctionId) != "boolean"){
            api.markError(parameterWithFunctionId);
            api.showErrorMessage(CUFCommon.t("default.wrong-function-type.boolean"));
            return false;
        }
		return true;
	}
};