/**
 * PWE form of ShowAndAttachDocumentsFromArchive.
 */
PWE.integrationComponent.registerApplication('copy-move-document-app', {
    apiVersion: 2,
    buildForm: function (form, options) {
        var me = this;
        form.addCombobox({
            id: "mode",
            values: [
                {
                    id: "COPYING",
                    display: CUFCommon.t("application.copy-move-document-app.copying")
                },
                {
                    id: "MOVING",
                    display: CUFCommon.t("application.copy-move-document-app.moving")
                }
            ]
        });
        CufComp.addComboboxClassList("doc-class-src", {
            change: function (value) {
                if (!form.hasVariableValue("doc-class-src") && !form.hasFunctionValue("doc-class-src")) {
                    me.indexesFromCombobox.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                    me.indexesFilterFromCombobox.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                }
            }
        }, form);
        CufComp.addComboboxClassList("doc-class-to", {
            change: function (value) {
                if (!form.hasVariableValue("doc-class-to") && !form.hasFunctionValue("doc-class-to")) {
                    me.indexesToCombobox.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                }
            }
        }, form);

        createFilterType(form);
        form.addField("doc-ids");
        createFilterTable(form);
        createIndexCopyTable(form);
        form.addField("save-as-new-version");
        form.addField("attach-to-process");
        form.addField("execute-actions");
        form.addField("new-version-only");

        if (form.getValue("filter-type").indexOf("DOCIDS") > -1) {
            form.show("doc-ids");
            form.hide("filterTable");
        } else {
            form.hide("doc-ids");
            form.show("filterTable");
        }



        backwardCompatibility(form);

        function createFilterTable(form) {
            var indexFilter = form.addTable({
                id: "filterTable",
                hidden: true,
                name: CUFCommon.t("application.copy-move-document-app.label.filter")
            });
            this.indexesFilterFromCombobox = CufComp.addComboboxClassIndexList("filter-index-name", form.getValue("doc-class-src"), null, indexFilter);
            this.indexesFilterFromCombobox.setForceSelection(false);
            indexFilter.addField("filter-index-value");
        };
        function createIndexCopyTable(form) {
            var indexTable = form.addTable({
                id: "indexTable",
                name: CUFCommon.t("application.copy-move-document-app.label.mapping_index")
            });
            this.indexesFromCombobox = CufComp.addComboboxClassIndexList("index-id-class-from", form.getValue("doc-class-src"), null, indexTable);
            this.indexesToCombobox = CufComp.addComboboxClassIndexList("index-id-class-to", form.getValue("doc-class-to"), null, indexTable);
        };

        function createFilterType(form) {
            form.addCombobox({
                id: "filter-type",
                values: [
                    {
                        id: "INDEXES",
                        display: CUFCommon.t("application.copy-move-document-app.idnexes")
                    },
                    {
                        id: "DOCIDS",
                        display: CUFCommon.t("application.copy-move-document-app.docids")
                    }
                ],
                listeners: {
                    change: function (value) {
                        if (value.indexOf("DOCIDS") > -1) {
                            form.show("doc-ids");
                            form.hide("filterTable");
                        } else {
                            form.hide("doc-ids");
                            form.show("filterTable");
                        }
                    }
                }
            });
        };
        function backwardCompatibility(form) {
            CufComp.setClassNameById(form, "doc-class-src");
            CufComp.setClassNameById(form, "doc-class-to");
            CufComp.setClassIndexesById(form, "doc-class-src", "index-id-class-from");
            CufComp.setClassIndexesById(form, "doc-class-to", "index-id-class-to");
        };
    }
});


