PWE.integrationComponent.registerFormAction('conditional-row-delete', {
	apiVersion: 2,
	buildForm: function(form, options) {
		form.addCombobox({
			id: "executeTypes",
			value: "CONDITIONAL_EXECUTE",
			values: [
				{ id: "UPDATING_VARIABLES", display: CUFCommon.t('action.set-variables.execute-type.updating-variables') },
				{ id: "CONDITIONAL_EXECUTE", display: CUFCommon.t('action.set-variables.execute-type.conditional-execute') }
			],
			listeners: {
				change: function(value) {
					handleExecuteTypes(value, form);
				}
			}
		});

		if (options.destination == "VARIABLESET") {
			form.addField({
				id: "buttonId",
				hidden: true
			});
			form.addField({
				id: "buttonName",
				hidden: true
			});
			form.addField({
				id: "condition"
			});
			if (form.getValue("buttonId")) {
				form.show("buttonId");
				form.show("buttonName");
				form.hide("executeTypes");
			} else {
				form.addField({
					id: "updatingVariables",
					optional: true
				});
			}
		}
		if (options.destination == "DT_BUTTON") {
			form.addField({
				id: "condition"
			});
			form.hide("executeTypes");
			form.setValue("executeTypes", "CONDITIONAL_EXECUTE")
		}

		handleExecuteTypes(form.getValue("executeTypes"), form);
	},

	validateForm: function(api) {
		if (this.variableSetDest) {
			if (api.getFunctionReturnType("condition") != "boolean") {
				api.markError("condition");
				api.showErrorMessage(CUFCommon.t("default.wrong-function-type.boolean"));
				return false;
			}
		}
	}
});
function handleExecuteTypes(fullValue, form) {
	if (fullValue.indexOf('UPDATING_VARIABLES') > -1) {
		form.show('updatingVariables');
	}
	else if (fullValue.indexOf('CONDITIONAL_EXECUTE') > -1) {
		form.hide('updatingVariables');
	}
}