PWE.integrationComponent.registerFormAction("check-oauth-token-expired", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addCombobox({
            id: "clientName",
            valueField: "id",
            displayField: "display",
            values: getOAuthClientNames(),
            listeners: {
                change: (clientName) => connectionNamesComboBox.setValues(getOAuthConnectionNames(clientName))
            }
        });

        const connectionNamesComboBox = form.addCombobox({
            id: "connectionName",
            valueField: "id",
            displayField: "display",
            values: getOAuthConnectionNames(form.getValue("clientName"))
        });

        form.addCombobox({
            id: "windowTarget",
            valueField: "id",
            displayField: "display",
            values: [
                {id: "_blank", display: CUFCommon.t("check-oauth-token-expired.windowTarget.blank")},
                {id: "popup", display: CUFCommon.t("check-oauth-token-expired.windowTarget.popup")}
            ]
        });
    }
});

function getOAuthClientNames() {
    let data = [];
    jQuery.ajax({
            url: PW.getAbsolutePath("api/oauth/clients"),
            success: function (result) {
                data = result.map(item => ({id: item.name, display: item.name}));
            },
            async: false
        }
    );

    return data;
}

function getOAuthConnectionNames(clientName) {
    if (!clientName) {
        return [];
    }

    let clientId;
    jQuery.ajax({
            url: PW.getAbsolutePath("api/oauth/clients/"),
            success: function (result) {
                clientId = result.find(client => client.name === clientName).id;
            },
            async: false
        }
    );

    let data = [];
    jQuery.ajax({
            url: PW.getAbsolutePath("api/oauth/clients/" + clientId),
            success: function (result) {
                data = result.connections.map(item => ({id: item.email, display: item.email}));
            },
            async: false
        }
    );

    return data;
}