PWE.integrationComponent.registerFormAction('block-table-buttons', {
	apiVersion: 2,
	buildForm: function(form, options) {
		form.addField('disableCondition');
		form.addCombobox({
			id: 'combo',
			name: CUFCommon
					.t('action.block-table-buttons.execution-type.name'),
			description: CUFCommon
					.t('action.block-table-buttons.execution-type.desc'),
			value: form.getValue('disableCondition', true) == '' ? 'condition-passed' : 'row-selected',
			values: [{
				id: 'condition-passed',
				display : CUFCommon
						.t('action.block-table-buttons.execution-type.condition-passed')
			}, {
				id: 'row-selected',
				display: CUFCommon
						.t('action.block-table-buttons.execution-type.row-selected')
			}],
			listeners: {
				change: function(value) {
					if (value == 'condition-passed') {
						form.setNotEmpty('disableCondition', false);
						form.hide('disableCondition');
						form.resetValue('disableCondition');
					} else if (value == 'row-selected') {
						form.setNotEmpty('disableCondition', true);
						form.show('disableCondition');
					}
				}
			}
		}, form.getFieldPosition('disableCondition'));
		form.addField('buttonsIds', form.getFieldPosition('disableCondition'));
		if (form.getValue('disableCondition', true) == '') {
			form.setNotEmpty('disableCondition', false);
			form.hide('disableCondition');
		} else {
			form.setNotEmpty('disableCondition', true);
		}
	}
});