PWE.integrationComponent.registerFormAction('add-row', {
    apiVersion: 2,
    buildForm: function (form, options) {
        const destination = options.destination;
        const table = form.addTable();
        table.addField("columns");
        table.addField("values");

        if (destination === "BUTTON") {
            form.addField("tableId");
        }

        form.addField({
            id: "setRowPosition",
            listeners: {
                change: value => value ? form.show("rowPosition") : form.hide("rowPosition")
            }
        });

        form.addField({
            id: "rowPosition",
            hidden: !form.getValue("setRowPosition")
        });
    }
});