
/**
 * Set specified variables with either the data connected with users substituted by a given user
 * or, in the case where this user is not substituting anyone at the time, his or her own data.
 */
PW.FormActions.create('substituted-users-action', {

	init : function() {
		this.userName = this.get("userName");
		this.targetUsername = this.get("targetUsername");
		this.targetEmail = this.get("targetEmail");
		this.targetPosition = this.get("targetPosition");
		this.targetSuperior = this.get("targetSuperior");
		this.downloadAllLevels = this.get("downloadAllLevels");
	},

	variableInit : function(variable) {
		variable.on("change", this.setData, this);
	},
	
	buttonInit : function(button) {
		this.button = button;
	},
	
	defaultActions: {
        button: function(button){
             this.setData();
         }
     },
	
	addToLock : function(variable) {
		this.lock = new Suncode.form.plugin.locking.Lock();
		this.lock.pushVariable(variable);
	},
	
	enable : function() {
		if (!this.button) {
			this.setData();
		}
	},

	setData : function() {
		var targetUsername = this.targetUsername,
			targetEmail = this.targetEmail,
			targetPosition = this.targetPosition,
			targetSuperior = this.targetSuperior,
			downloadAllLevels = this.get("downloadAllLevels");


		this.addToLock(targetUsername);
		this.addToLock(targetEmail);
		this.addToLock(targetPosition);
		this.addToLock(targetSuperior);

		var lock = this.lock,
			userName = this.get("userName");
		lock.lock();
		var request = jQuery.ajax({
			type : "GET",
			data : {
				userName : userName,
				downloadAllLevels : downloadAllLevels
			},
			url : "plugin/com.suncode-cuf-components/user/get-substitute/",
			error :  function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			}, 
			async : true
		})
		.done(function (data){
			if (devMode){
	    		Logger.debug("Action user-substituted-data will now set variables...");
	    	}
		    if(targetUsername){
				let isArrayVariable = targetUsername.type.name === "string[]";
				targetUsername.setValue( isArrayVariable? data.usernames.split(';'): data.usernames );
		    }
			if(targetEmail){
			    targetEmail.setValue(data.emails);
			}
			if(targetPosition){
			    targetPosition.setValue(data.positions);
			}
			if(targetSuperior){
			    targetSuperior.setValue(data.superiors);
			}
		})
		.fail(function(){
			Logger.error("Request failed.");
		})
		.always(function(){
			lock.unlock();
		});
	}
});