PW.FormActions.create('user-belongs-to-group-action', {
	formInit: function() {
		this.userNames = this.get('userName');
		this.groupsList = this.get('groupsList');
		this.targetVariable = this.get('targetVariable');
		this.checkIfUserBelongsToGroupsForm();
	},
	variableSetInit: function(variableSet) {
		this.getRaw('matchAll').on('change', function() {
			variableSet.fireChangeEvent();
		});
		this.variableSet = variableSet;
	},
	enable: function() {
		if (this.target.type == 'FORM') {
			this.get('userName').on('change', this.checkIfUserBelongsToGroupsForm, this);
			this.get('groupsList').on('change', this.checkIfUserBelongsToGroupsForm, this);
			this.checkIfUserBelongsToGroupsForm();
		} else {
			this.variableSet.fireChangeEvent();
		}
	},
	disable: function() {
		var me = this;
		if (this.target.type == 'FORM') {
			this.get('userName').off('change', this.checkIfUserBelongsToGroupsForm, me);
			this.get('groupsList').off('change', this.checkIfUserBelongsToGroupsForm, me);
		}
	},
	defaultActions: {
		variableSet: function(variableSetObj, added, updated) {
			try {
				this.userNames = this.get('userName');
				this.groupsList = this.get('groupsList');
				this.matchAll = this.get('matchAll');
				this.trueValue = this.get('trueValue');
				this.falseValue = this.get('falseValue');
				this.targetVariable = this.get('targetVariable');
				this.separator = this.get('separator') || ',';
				if (this.userNames.type.name !== 'string[]' || this.groupsList.type.name !== 'string[]'
				|| this.targetVariable.type.name !== 'string[]') {
					Logger.error("'" + this.userNames.name + "', '" + this.groupsList.name + "' and '" + this.targetVariable.name
						+ "' variables has to be of string[] type!");
					return;
				}
				if (added.length === 0 && updated.length === 0) {
					updated = this.variableSet.getRecords().map(function(record, index) {
						return { index: index, record: record }
					});
				}
				added.concat(updated).forEach(function(arrayItem) {
					var userNameString = arrayItem.record.record.data[this.userNames.id];
					var groupsListArray = arrayItem.record.record.data[this.groupsList.id] === ''
						? []
						: arrayItem.record.record.data[this.groupsList.id].split(this.separator);
					if (userNameString !== '' && groupsListArray.length > 0) {
						this.checkIfUserBelongsToGroups(userNameString, groupsListArray, arrayItem.index, false);
					}
				}.bind(this));
			} catch(err) {
				console.error(err);
			}
		},
		variable: function() {
			this.requestData();
		}
	},
	checkIfUserBelongsToGroupsForm: function() {
		userName = this.userNames.getValue();
		var separator = this.separator = this.get('separator') || ',';
		groupsList = this.groupsList.getValue() === ''
			? []
			: this.groupsList.getValue().split(separator);
		this.checkIfUserBelongsToGroups(userName, groupsList, -1);
	},
	checkIfUserBelongsToGroups: function(userName, groupsList, index) {
		var matchAll = this.get('matchAll');
		var trueValue = this.get('trueValue');
		var falseValue = this.get('falseValue');

		if (userName.length && groupsList.length) {
			jQuery.ajax({
				type: 'GET',
				data: {
					username: userName,
					dataTypes: ['GROUPSNAMES']
				},
				url: PW.getAbsolutePath('plugin/com.suncode-cuf-components/user/user-data'),
				error: function(errorThrown) {
					Logger.error(errorThrown);
				},
				async: true
			})
				.done(function(response) {
					var userGroupsList = response['GROUPSNAMES'] ? response['GROUPSNAMES'].split(';') : null;
					var targetVariableValue = this.targetVariable.getValue();
					if (userGroupsList === null) {
						Logger.error("Either user '" + userName + "' does not exists or is not associated with any group!");
						if (index > -1) {
							targetVariableValue[index] = falseValue;	
						} else {							
							targetVariableValue = falseValue;
						}
						this.targetVariable.setValue(targetVariableValue);
						return;
					}
					var targetVar = index > -1 ? targetVariableValue[index] : targetVariableValue;
					if (matchAll) {
						targetVar = trueValue;
						groupsList.forEach(function(groupName) {
							if (userGroupsList.indexOf(groupName) === -1) {
								targetVar = falseValue;
								return;
							}
						}.bind(this));
					} else {
						targetVar = falseValue;
						userGroupsList.forEach(function(groupName) {
							if (groupsList.indexOf(groupName) > -1) {
								targetVar = trueValue;
								return;
							}
						}.bind(this));
					}
					if (index > -1) {
						targetVariableValue[index] = targetVar;
						this.variableSet.suspendEvents(false);
						this.targetVariable.setValue(targetVariableValue);
						this.variableSet.resumeEvents();
					} else {
						this.targetVariable.setValue(targetVar);
					}
				}.bind(this))
				.fail(function() {
					Logger.error('Request failed.');
				});
		}
	},
});