PW.FormActions.create('storage-data-set-date-array-action', {
		
	enable: function() {
		if (this.target.type == "FORM"){
			this.setFormalParameter();
		}
	},
	
	defaultActions : {
		variable: function() {
			this.setFormalParameter();
		},
		button: function() {
			this.setFormalParameter();
		},
		variableSet: function() {
			this.setFormalParameter();
		},
		dtButton: function() {
			this.setFormalParameter();
		},
	},
	
	setFormalParameter: function() {
		var formalParameterText = VariableService.getValue("StorageData");
		var paramName = this.get("paramName");
		var paramValue = this.get("paramValue");
		if (!StorageData.isStringValidJsonObject(formalParameterText)) {
			formalParameterText = "{}";
		}
		var formalParameterObject = JSON.parse(formalParameterText);
		var dateArray = this.createDateArrayAsText(paramValue);
		formalParameterObject[paramName] = dateArray;
		ServerLogger.debug("A parameter with key: '" + paramName + "' and value: [" +
				dateArray.join(', ') + "] has been added/replaced in StorageData");
		VariableService.setValue("StorageData", JSON.stringify(formalParameterObject, null, 2));
	},
	
	createDateArrayAsText: function(dates){
		var dateArray = [];
		PW.each(dates, function(date){
			dateArray.push(StorageData.createDateAsText(date));
		});
		return dateArray;
	}
});
