PW.FormActions.create('storage-data-remove-parameters-action', {

	enable : function() {
		if (this.target.type == "FORM") {
			this.removeParameters();
		}
	},

	defaultActions : {
		variable : function() {
			this.removeParameters();
		},
		button : function() {
			this.removeParameters();
		},
		variableSet : function() {
			this.removeParameters();
		},
		dtButton : function() {
			this.removeParameters();
		},
	},

	removeParameters : function() {
		var formalParameterText = VariableService.getValue("StorageData");
		var paramNames = this.get("paramNames");
		if (!StorageData.isStringValidJsonObject(formalParameterText)) {
			throw new Error("[storage-data-remove-parameters] - StorageData does not represent JSON object");
		}
		var formalParameterObject = JSON.parse(formalParameterText);
		formalParameterObject = this.remove(formalParameterObject, paramNames);
		ServerLogger.debug("Parameters with name: [" + paramNames.join(', ') + "] have been removed from StorageData");
		VariableService.setValue("StorageData", JSON.stringify(formalParameterObject, null, 2));
	},
	
	remove : function(formalParameter, paramNames){
		PW.each(paramNames, function(paramName){
			delete formalParameter[paramName];
		});
		return formalParameter;
	},
});
