PW.FormActions.create('set-variables', {

	labelInit: function(label) {
		this.label = label;
	},

	init: function() {
		if (this.target.type != "LABEL") {
			this.variables = this.get("variables");
		}
	},

	defaultActions: {
		button: function(button) {
			this.setVariables();
		},
		dtButton: function(button) {
			this.setVariables();
		},
	},

	enable: function() {
		if (this.target.type != "BUTTON") {
			this.checkTypeAndExecute();
		}
	},

	disable: function() {
		var me = this;
		var typeOfExecution = this.get("executeType") ? this.get("executeType") : this.get("executeTypes");
		if (typeOfExecution.indexOf("UPDATING_VARIABLES") > -1) {
			PW.each(me.get("updatingVariables"), function(variable) {
				variable.off("change", me.setValues, me);
			});
		}
	},

	checkTypeAndExecute: function() {
		var me = this;
		var typeOfExecution = this.get("executeType") ? this.get("executeType") : this.get("executeTypes");
		if (typeOfExecution.indexOf("UPDATING_VARIABLES") > -1) {
			PW.each(me.get("updatingVariables"), function(variable) {
				variable.on("change", me.setValues, me);
			});
		}
		else if (typeOfExecution.indexOf("CONDITIONAL_EXECUTE") > -1) {
			me.setValues();
		}
	},

	setValues: function() {
		if (this.label) {
			this.setLabel();
		}
		else {
			this.setVariables();
		}
	},

	setLabel: function() {
		this.label.setText(this.get("labelValueToSet"));
	},

	setVariables: function() {
		var me = this;
		var valuesRaw = me.getRaw("values").value;
		if (devMode) {
			Logger.debug("Action set-variables will now set variables...");
		}
		PW.each(me.variables, function(variable, index) {
			var type = variable.getType();
			var stringValue = me.getStringValue(valuesRaw[index]);
			var value = type.isArray ? stringValue.split(";") : stringValue;
			variable.setValue(value);
		});
	},

	getStringValue: function(value) {
		if (value.is("variable")) {
			var variable = value.get();
			if (variable.isVariableSetVariable) {
				var arrayValue = variable.getValue();
				return arrayValue.join(";");
			}
			return variable.getValue();
		}
		if (value.is("function")) {
			var valueFunction = value.get();
			if (valueFunction.getReturnType().is("string[]")) {
				var arrayValue = value.getAs("string[]");
				return arrayValue.join(";");
			}
			return value.getAs('string');
		}
		return value.get();
	}
});