/**
 * Set sequenced number action.
 */
PW.FormActions.create('set-seqnumber', {

	buttonInit : function(button) {
		this.button = button;
	},
	
	enable : function() {
		if (!this.button) {
		    var me = this;
		    if (PW.isEmpty(this.get("executeTypes"))){
	            me.lockAndSetNumber();
	        }
		    else{
		    	if (this.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1){
		            PW.each(me.get("updatingVariables"), function (variable){
		                variable.on("change", me.lockAndSetNumber, me);
		            });
		        }
		        if (this.get("executeTypes").indexOf("CONDITIONAL_EXECUTE") > -1 ){
		            me.lockAndSetNumber();
		        }
		    }
		}
		else{
		    this.button.on("click", this.lockAndSetNumber, this);
		}
	},
	
	disable : function(){
        var me = this;
        if (me.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1){
            PW.each(me.get("updatingVariables"), function (variable){
                variable.off("change", me.lockAndSetNumber, me);
            });
        }
        if (this.button){
            this.button.off("click", this.lockAndSetNumber, this);
        }
        
    },
    
	lockAndSetNumber : function() {
		this.addToLock(this.get("targetVariable"));		
		this.setSequencedNo(this.get("format"), this.getSequenceName());
	},
	
	addToLock : function(variable) {
        this.lock = new Suncode.form.plugin.locking.Lock();
        this.lock.pushVariable(variable);
        this.lock.lock();
    },
	
	getSequenceName : function() {
	    var sequenceName = this.get("sequenceName");
        if (!this.get("sequenceName")) {
            sequenceName = ActivityInfoService.getProcessDefId() + "_" + this.get("targetVariable").id;
        }
        if (this.get("specialCharacters")) {
            sequenceName = sequenceName.replace(/[^a-zA-Z0-9]/g, '_');
        }
        return sequenceName;
	},

	setSequencedNo : function(numberFormat, sequenceName) {
	    var me = this;
		var request = jQuery.ajax({
			type : "GET",
			cache: false,
			data : {
				numberFormat : numberFormat,
				sequenceName : sequenceName
			},
			url : "plugin/com.suncode-cuf-components/sequence/number/",
			error :  function(jqXHR, textStatus, errorThrown) {
				Logger.error(errorThrown);
			}, 
			async : true
		})
		.done(function (data){
			if (devMode){
	    		Logger.debug("Action set-sequenced-no will now set variable...");
	    	}
			me.get("targetVariable").setValue(data);
			FormService.save();
		})
		.fail(function(){
			Logger.error("Request failed.");
		})
		.always(function(){
			me.lock.unlock();
		});
	}
});