PW.FormActions.create('rename-variables', {

    variableSetInit : function(table){
        this.table = table;
    },

    buttonInit: function(button){
    	this.button = button;
    },

    labelInit : function(label){
		this.label = label;
	},

	variableInit: function(variable){
	    this.variable = variable;
	},

	dtButtonInit: function (dtButton) {
    	this.dtButton = dtButton;
    },
	
	enable: function(){
		switch (this.target.type){
			case "BUTTON":
				this.button.setText(this.get("newNameElement"));
				this.getRaw("newNameElement").on("change", this.setElementName, this);
				break;
			case "DT_BUTTON":
				this.dtButton.setText(this.get("newNameElement"));
				if (this.get("newElementDescription")) {
					let variableSet = VariableSetService.get(this.dtButton.variableSet.getId());
					this.setDtButtonDescription(variableSet, this.target.id, this.get("newElementDescription"));
				}
				this.getRaw("newNameElement").on("change", this.setElementName, this);
				this.getRaw("newElementDescription").on("change", this.setElementDescription, this);
				break;
			case "LABEL":
				this.label.setText(this.get("newNameElement"));
				this.getRaw("newNameElement").on("change", this.setElementName, this);
				break;
			case "VARIABLE":
				this.variable.setName(this.get("newNameElement"));
				if (this.get("newElementDescription")) {
					this.setFormVariableDescription(this.target.id, this.get("newElementDescription"));
				}
				this.getRaw("newNameElement").on("change", this.setElementName, this);
				this.getRaw("newElementDescription").on("change", this.setElementDescription, this);
				break;
			case "FORM":
				this.changeNamesAndDescriptions();
				this.getRaw("newNameForm").on("change", this.changeNamesAndDescriptions, this);
				this.getRaw("newElementsDescription").on("change", this.changeNamesAndDescriptions, this);
				break;
			case "VARIABLESET":
				this.table.setTitle(this.get("newNameElement"));
				this.getRaw("newNameElement").on("change", this.setElementName, this);
				break;				
		}
    },

    disable: function(){
    	switch (this.target.type){
    		case "BUTTON":
    			this.getRaw("newNameElement").off("change", this.setElementName, this);
    			break;
    		case "DT_BUTTON":
    			this.getRaw("newNameElement").off("change", this.setElementName, this);
				this.getRaw("newElementDescription").off("change", this.setElementDescription, this);
    			break;
    		case "LABEL":    			
    			this.getRaw("newNameElement").off("change", this.setElementName, this);
    			break;
    		case "VARIABLE":
    			this.getRaw("newNameElement").off("change", this.setElementName, this);
				this.getRaw("newElementDescription").off("change", this.setElementDescription, this);
    			break;
    		case "FORM":
				this.getRaw("newNameForm").off("change", this.changeNamesAndDescriptions, this);
				this.getRaw("newElementsDescription").off("change", this.changeNamesAndDescriptions, this);
    			break;
    		case "VARIABLESET":
    			this.getRaw("newNameElement").off("change", this.setElementName, this);
				break;
    	}
    },

	changeNamesAndDescriptions: function() {
		let namesToChange = this.get("namesToChange");
		let newName = this.get("newNameForm");
		let newDescriptions = this.get("newElementsDescription");
		for (let i = 0; i < namesToChange.length; i++ ) {
			namesToChange[i].setName(newName[i]);
			if (newDescriptions[i]) {
				let type = namesToChange[i].variableSet ? "TABLE_VARIABLE" : "FORM_VARIABLE";
				this.setVariableDescriptionOnForm(type, namesToChange[i], newDescriptions[i]);
			}
		}
	},

    setElementName: function(arg){
    	switch(this.target.type){
    		case "LABEL": 
    			this.label.setText(arg.get());
    			break;
    		case "VARIABLE":
    			this.variable.setName(arg.get());
    			break;
    		case "VARIABLESET":
    			this.table.setTitle(arg.get());
    			break;
    		case "BUTTON":
    			this.button.setText(arg.get());
    			break; 	
    		case "DT_BUTTON":
    			this.dtButton.setText(arg.get());
    			break;
    	}
    },

	setElementDescription: function(arg){
		switch(this.target.type){
			case "VARIABLE":
				this.setFormVariableDescription(this.target.id, arg.get());
				break;
			case "DT_BUTTON": {
				let variableSet = VariableSetService.get(this.dtButton.variableSet.getId());
				this.setDtButtonDescription(variableSet, this.target.id, arg.get());
				break;
			}
		}
	},

	setVariableDescriptionOnForm: function(type, element, description) {
		switch(type){
			case "FORM_VARIABLE": {
				let variableId = element.getId();
				this.setFormVariableDescription(variableId, description);
				break;
			}
			case "TABLE_VARIABLE": {
				let variableSet = VariableSetService.get(element.getVariableSet().getId());
				let variableId = element.getId();
				this.setTabularVariableDescription(variableSet, variableId, description);
				break;
			}
		}
	},

	setFormVariableDescription: function(variableId, description) {
		VariableService.setDescription(variableId, description);
	},

	setTabularVariableDescription: function(variableSet, variableId, description) {
		VariableSetService.setColumnDescription(variableSet, variableId, description);
	},

	setDtButtonDescription: function(variableSet, dtButtonId, description) {
		VariableSetService.setBottomToolbarButtonDescription(variableSet, dtButtonId, description);
	}
});
