/**
 * Import from excel implementation
 */
PW.FormActions.create('import-from-excel', {

    dtButtonInit: function (button) {
        this.table = button.getVariableSet();
    },

    variableSetInit: function (table) {
        this.table = table;

        if (MobileService.isMobile()) {
            return;
        }

        var me = this;
        this.tableButtonId = 'importExcelTableButton-' + this.table.getId();
        ServiceFactory.getVariableSetService().addBottomToolbarButton(table.grid, {
            text: CUFCommon.t('action.import-from-excel.buttonName'),
            itemId: this.tableButtonId,
            iconCls: 'silk-page-excel',
            disabled: true,
            handler: function () {
                me.importFromExcel();
            }
        });
    },

    enable: function () {
        if (MobileService.isMobile()) {
            return;
        }

        if (this.target.type == 'VARIABLESET') {
            ServiceFactory.getVariableSetService().enableBottomToolbarButton(this.table.grid, this.tableButtonId);
        }
    },

    disable: function () {
        if (MobileService.isMobile()) {
            return;
        }

        if (this.target.type == 'VARIABLESET') {
            ServiceFactory.getVariableSetService().disableBottomToolbarButton(this.table.grid, this.tableButtonId);
        }
    },

    defaultActions: {
        dtButton: function (button) {
            if (MobileService.isMobile()) {
                MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
                return;
            }

            this.importFromExcel();
        }
    },

    importFromExcel: function () {
        const config = this.getConfig(this.table);
        CUF.table.core.TableService.importDataFromExcel(this.table.grid, config);
    },

    getConfig: function (table) {
        var me = this;
        if (me.get("acceptForm") && !FormService._getActionAcceptButton(me.get("actionName"))) {
            MessageService.showFailure(CUFCommon.t('action.error.config'));
            throw "Incorrect parameter actionName: " + me.get("actionName");
        }
        return {
            filters: this.getFilteredData(),
            columnsToImport: this.getColumnsToImport(),
            overrideCheckBox: this.get("overrideCheckBox"),
            includeHiddenColumns: this.get("includeHiddenColumns"),
            dataChoosersWithSuspendedAutomappings: this.getDatachoosersToSuspend(),
            saveData: me.get("acceptForm") ? false : this.get("saveData"),
            beforeImport: function () {
                CUFCommon.addProcessedTable(table.getId());
            },
            callback: function () {
                CUFCommon.removeProcessedTable(table.getId());
                if (me.get("acceptForm")) {
                    FormService.accept({actionName: me.get("actionName")});
                }
            }
        };
    },

    getDatachoosersToSuspend: function () {
        if (!this.shouldSuspendAutoMappings()) {
            return [];
        }

        var variables = this.table.getVariables();
        if (this.get("automappings") == "ENABLE_CUSTOM") {
            var enabledVariables = this.get("variablesWithAutomapping");
            variables = PW.filter(this.table.getVariables(), function (variable) {
                return PW.find(enabledVariables, function (enabledVariable) {
                    return enabledVariable.getId() == variable.getId();
                }) ? false : true;
            });
        }
        return PW.map(variables, function (variable) {
            return variable.getId();
        });
    },

    shouldSuspendAutoMappings: function () {
        var automappings = this.get("automappings");
        return automappings == "ENABLE_CUSTOM" || automappings == "DISABLE_ALL";
    },

    getFilteredData: function () {
        var filters = [];
        var columns = this.get("columns");
        var filterValues = this.get("filterValues");
        var filterTypes = this.get("filterTypes");
        for (var i = 0; i < columns.length; i++) {
            var filter = {
                colName: columns[i].getId(),
                value: filterValues[i],
                type: filterTypes[i]
            };
            filters.push(filter);
        }
        return filters;
    },

    getColumnsToImport: function () {
        var columns = [];
        PW.each(this.get("columnsToImport"), function (column) {
            columns.push(column.getName());
        }, this);
        return columns;
    }
});