PW.FormActions.create('find-duplicates-action', {

    defaultActions: {
        button: function (button) {
            this.findDuplicates();
        }
    },

    enable: function () {
        var me = this;
        if (this.target.type != 'BUTTON') {
            if (me.get("initExecute")) {
                me.findDuplicates();
            }
            PW.each(me.get("variablesToCheck"), function (variable) {
                variable.on("change", me.findDuplicates, me);
            });
        }
    },

    disable: function () {
        var me = this;
        if (this.target.type != 'BUTTON') {
            PW.each(me.get("variablesToCheck"), function (variable) {
                variable.off("change", me.findDuplicates, me);
            });
        }
    },

    findDuplicates: function () {
        this.unmarkErrors();
        var cfg = {
            variablesToCheck: this.getVariablesDto(this.get("variablesToCheck")),
            message: this.get("message"),
            variablesExcludingDuplicates: this.getVariablesDto(this.get("variablesExcludingDuplicates"), this.get("valuesExcludingDuplicates")),
            processesType: this.get("processesType"),
            caseSensitive: this.get("caseSensitive"),
            processDefId: ActivityInfoService.getProcessDefId(),
            processId: ActivityInfoService.getProcessId(),
        };
        var me = this;
        jQuery.ajax({
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(cfg),
            url: "plugin/com.suncode-cuf-components/processes/duplicates/",
            error: function (jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            },
            async: true
        })
            .done(function (data) {
                if (data.length) {
                    me.duplicatesProcessesIds = data;
                    if (me.get("duplicatePresentationComboBox") == "BASIC") {
                        me.showDuplicateWindow();
                    }
                    if (me.get("duplicatePresentationComboBox") == "EXTENDEND") {
                        me.showDuplicatesWindow();
                    }
                    me.setNumberOfDuplicates(data.length);
                    me.markErrors();
                } else {
                    me.setNumberOfDuplicates(0);
                }
            });
    },

    setNumberOfDuplicates: function (numberOfDuplicates) {
        var targetVariable = this.get("numberOfDuplicatesFound");
        if (targetVariable) {
            if (targetVariable.getType().is("integer")) {
                targetVariable.setValue(numberOfDuplicates);
            } else {
                Logger.error("Cannot set number of found duplicates, because variable [" + targetVariable.getName() + "] is not an integer type.");
            }
        }
    },

    defineDuplicateWindow: function (id, scope) {
        return new Ext4.define(id, {
            extend: 'Ext4.window.Window',
            width: 600,
            layout: 'fit',
            modal: true,
            buttonAlign: 'right',
            closable: false,
            title: CUFCommon.t('action.find-duplicates-action.duplicates-found-title'),
            items: [
                {
                    margin: '0 10 20 10',
                    xtype: 'component',
                    html: CUFCommon.t('action.find-duplicates-action.duplicates-found-body') + scope.getVariablesToCheckNames()
                }],

            buttons: [{
                text: CUFCommon.t('action.find-duplicates-action.continue-button'),
                itemId: 'continueButton',
                handler: function () {
                    this.duplicateWindow.hide();
                },
                scope: scope
            },
                {
                    text: CUFCommon.t('action.find-duplicates-action.details-button'),
                    itemId: 'detailsButton',
                    handler: this.showDuplicatesWindow,
                    scope: scope
                }]
        });
    },

    getVariablesToCheckNames: function () {
        var ids = [];
        PW.each(this.get("variablesToCheck"), function (variable) {
            ids.push(variable.getName());
        });
        return ids.join(", ");
    },

    showDuplicateWindow: function () {
        if (MobileService.isMobile()) {
            MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
            return;
        }

        if (!this.duplicateWindow) {
            var windowId = 'find-duplicates-action' + CUFCommon.generateDefaultButtonId();
            this.defineDuplicateWindow(windowId, this);
            this.duplicateWindow = Ext4.create(windowId);
        }
        this.duplicateWindow.show();
    },

    getVariablesDto: function (variables, values) {
        var variablesDto = [];
        PW.each(variables, function (variable, index) {
            var value = values ? values[index] : this.getValueFromVariable(variable);
            variablesDto.push({id: variable.getId(), value: value, stringType: variable.getType().name});
        }, this);
        return variablesDto;
    },

    getValueFromVariable: function (variable) {
        if (variable.getType().isArray) {
            return VariableSetService.getValue(variable.getVariableSet(), null, variable.getId());
        }
        return VariableService.getValue(variable.getId(), true);
    },

    markErrors: function () {
        PW.each(this.get("variablesToCheck"), function (variable) {
            VariableService.markError(variable.getId(), this.get("message"));
        }, this);
    },

    unmarkErrors: function () {
        PW.each(this.get("variablesToCheck"), function (variable) {
            VariableService.unmarkError(variable.getId());
        }, this);
    },

    showDuplicatesWindow: function () {
        var data = this.duplicatesProcessesIds;
        var me = this;
        var cfg = {
            filters: [],
            sorters: [],
            processDefId: ActivityInfoService.getProcessDefId(),
            processIds: data,
            userName: sTaskUserName,
            variablesIds: me.getColumnIndexes(),
        }
        me.cufWindow = CUF.DataService.showDataWin({
            query: cfg,
            type: 'webservice',
            winCfg: {
                title: CUFCommon.t('action.find-duplicates-action.duplicates-window-title'),
                overflowX: 'auto'
            },
            columns: me.getColumnParameters(),
            fields: me.getFields(),
            url: 'plugin/com.suncode-cuf-components/processes/data',
            gridCfg: {
                tbar: me.get("saveDataToVariables") ? me.getButtons() : [],
                numbered: true,
                checkboxSelection: me.get("saveDataToVariables"),
                selectionType: 'SINGLE',
                showRowCount: true,
                pageSize: Suncode.getUserPageSize(),
                rememberSelection: true,
                minWidth: 1100
            }
        });
    },

    getButtons: function () {
        var me = this;
        return [
            {
                text: me.get("setDataButtonName"),
                xtype: 'button',
                handler: function () {
                    var grid = this.up("grid");
                    me.moveSelected(grid);
                    me.cufWindow.hide();
                }
            }
        ];
    },

    moveSelected: function (grid) {
        return PW.map(this.get("variablesToGetData"), function (variable, i) {
            var selected = grid.getSelectionModel().getSelection()[0];
            this.get("variablesToSetData")[i].setValue(selected.get(variable.getId()));
        }, this);
    },

    getColumnParameters: function () {
        var params = [];
        if (this.get("addColumnWithProcessName")) {
            params.push({
                text: CUFCommon.t('default.process-name'),
                dataIndex: "process_name",
                flex: 1
            });
        }
        params = params.concat(PW.map(this.get("dataVariables"), function (variable, i) {
            return {
                text: variable.getName(),
                dataIndex: variable.getId(),
                filter: this.getFilter(variable),
                hidden: this.get("isHiddenColumn") ? this.get("isHiddenColumn")[i] : false,
                flex: 1,
                renderer: this.getRenderer(variable),
                sortable: false
            };
        }, this));
        if (this.get("addLinkToDocuments")) {
            params.push({
                text: CUFCommon.t('default.documents-preview'),
                dataIndex: "document_preview",
                flex: 1,
                sortable: false
            });
        }
        if (this.get("addLinkToProcess")) {
            params.push({
                text: CUFCommon.t('default.link-to-process'),
                dataIndex: "link_to_process",
                flex: 1
            });
        }
        return params;
    },

    getFilter: function (variable) {
        if (this.isVariableToCheck(variable)) {
            return;
        }
        if (variable.getType().is("string")) {
            return CUF.DataFilters.like();
        } else if (variable.getType().is("integer")) {
            return CUF.DataFilters.betweenInt();
        } else if (variable.getType().is("float")) {
            return CUF.DataFilters.betweenDouble();
        } else if (variable.getType().is("date")) {
            return CUF.DataFilters.betweenDate();
        }
        return;
    },

    getRenderer: function (variable) {
        if (variable.getType().is("integer")) {
            return spaceFormatting;
        }
        if (variable.getType().is("float")) {
            return spaceAndCommasFormatting;
        }
        return;
    },

    isVariableToCheck: function (variable) {
        for (var i = 0; i < this.get("variablesToCheck").length; i++) {
            if (this.get("variablesToCheck")[i].getId() == variable.getId()) {
                return true;
            }
        }
        return false;
    },

    getColumnIndexes: function () {
        return PW.map(this.get("dataVariables"), function (variable, i) {
            return variable.getId();
        }, this);
    },

    getFields: function () {
        var fields = [];
        if (this.get("addColumnWithProcessName")) {
            fields.push("process_name");
        }
        fields = fields.concat(this.getColumnIndexes());
        if (this.get("addLinkToDocuments")) {
            fields.push("document_preview");
        }
        if (this.get("addLinkToProcess")) {
            fields.push("link_to_process");
        }
        return fields;
    }
});

(function ($) {
    var translations = {};
    window.ProcessSearchDocumentsPreview = {
        translations: function (t) {
            translations = t;
        }
    };

    var informationWindow,
        documentsPreviewWindow;


    /**
     * Funkcja wyswietlająca okno z podlgądem dokumentu
     */
    var showDocumentPreview = function (document) {
        if (MobileService.isMobile()) {
            MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
            return;
        }

        var body = Ext.getBody();
        var windowParams = 'menubar=no,toolbar=no,location=no,';
        windowParams += 'directories=no,status=no,scrollbars=yes,';
        windowParams += 'resizable=yes,fullscreen=no,channelmode=no,';
        windowParams += 'width=' + body.getWidth() / 2 + ',height=' + body.getHeight() + ',';
        windowParams += 'left=' + body.getWidth() / 2 + ',top=0';

        window.open(document.url || document.data.url, 'viewer', windowParams).focus();
    };

    var showDocumentsInformation = function (record, e) {
        informationWindow = showPopup(record.data.urlInformation, translations['document.information'], e.getPageX(), e.getPageY());
    };

    /**
     * Okno podglądu wielu dokumentów
     */
    var PreviewWindow = Ext.extend(Ext.Window, {
        layout: 'fit',
        width: 600,
        frame: false,
        closable: false,
        resizable: false,
        header: false,
        cls: 'process-search-documents-preview',
        style: 'background-color: white;',

        constructor: function (documents) {
            this.destroyOtherInstance();

            this.documents = documents;
            this.containsInformation = documents[0].containsInformation;
            PreviewWindow.superclass.constructor.call(this);
        },

        initComponent: function () {
            var me = this;

            var columns = [{
                dataIndex: 'name',
                tpl: '<span ext:qtip="{name}">{name}</span>',
                header: CUFCommon.t('default.document.name')
            }, {
                dataIndex: 'description',
                width: 0.3,
                tpl: '<span ext:qtip="{description}">{description}</span>',
                header: CUFCommon.t('default.document.description')
            }, {
                dataIndex: 'documentClass',
                width: 0.2,
                tpl: '<span ext:qtip="{documentClass}">{documentClass}</span>',
                header: CUFCommon.t('default.document.class')
            }];

            if (this.containsInformation === true) {
                var informationColumn = {
                    align: 'center',
                    width: 0.1,
                    tpl: '<span class="silk-information" style="height:16px;width:16px;display:inline-block;"></span>'
                };
                columns.splice(3, 0, informationColumn);
            }

            this.items = [{
                xtype: 'listview',
                cls: 'documents-preview-list',
                boxMaxHeight: 300,
                store: new Ext.data.JsonStore({
                    fields: [{
                        name: 'name',
                        convert: function (v) {
                            return Ext.util.Format.htmlEncode(v);
                        }
                    }, 'url', 'urlInformation', 'documentClass', 'description',
                        {
                            name: 'date',
                            type: 'date'
                        }, {
                            name: 'containsInformation',
                            type: 'boolean'
                        }],
                    data: this.documents,
                    sortInfo: {
                        field: 'date',
                        direction: 'DESC'
                    }
                }),
                columns: columns,
                listeners: {
                    scope: this,
                    click: this.manageCellClick
                },
                refresh: function () {
                    var r = Ext.list.ListView.prototype.refresh.call(this);
                    me.drawOddRows();
                    return r;
                },
                bufferRender: function () {
                    var r = Ext.list.ListView.prototype.bufferRender.call(this);
                    me.drawOddRows();
                    return r;
                }
            }],

                this.bbar = ['->', {
                    text: translations["close"],
                    iconCls: 'silk-cross',
                    handler: this.close,
                    scope: this
                }];

            this.initAutoClose();
            PreviewWindow.superclass.initComponent.call(this);
        },

        destroyOtherInstance: function () {
            if (documentsPreviewWindow) {
                documentsPreviewWindow.close();
            }
            documentsPreviewWindow = this;
        },

        showBy: function (target) {
            this.show();

            var xy = this.el.getAlignToXY(target, 'tl-bl?');
            var rightArea = xy[0] > (Ext.getBody().getWidth() / 2);
            this.setPosition(xy[0] - (rightArea ? 15 : 0), xy[1]);
        },

        manageCellClick: function (view, index, node, e) {
            var record = view.getRecord(node);
            var target = $(e.target);

            if (target.is('.silk-information') || target.children().is('.silk-information')) {
                showDocumentsInformation(record, e);
            } else {
                showDocumentPreview(record);
            }
        },

        drawOddRows: function () {
            if (this.el) {
                $(this.el.dom).find('dl:odd').addClass('documents-preview-list-odd');
            }
        },

        initAutoClose: function () {
            this.on('afterrender', function () {
                Ext.getBody().on('mousedown', function (e) {
                    if (!e.within(this.el)) {
                        if (informationWindow && e.within(informationWindow.el)) {
                            return;
                        }
                        this.close();
                    }
                }, this);
            }, this);
        },

        destroy: function () {
            documentsPreviewWindow = undefined;

            Ext.getBody().un('mousedown', this.close, this);
            return PreviewWindow.superclass.destroy.call(this);
        }
    });

    $(function () {
        var singleHoverId;
        var showPreview = function (elem) {
            new PreviewWindow($(elem).data('documents')).showBy(elem);
            jQuery('.process-search-documents-preview').css('z-index', '100000');
        };

        var hover = function (target) {
            return target.hover(function () {

                var me = this;
                singleHoverId = setTimeout(function () {
                    showPreview(me);
                }, 1000);
            }, function () {
                clearTimeout(singleHoverId);
            });
        };

        // 1. Linki do pojedynczych dokumentów uruchamiają od razu podgląd dokumentów
        hover($('.document-preview-single')).click(function () {
            var doc = $(this).data('documents')[0];
            showDocumentPreview(doc);
            clearTimeout(singleHoverId);
        });

        // 2. Linki do listy dokumentów wyświetlają okno wyboru dokumentu
        hover($('.document-preview-multiple')).click(function () {
            showPreview(this);
        });

        window.onClickPreviewDoc = function (btn) {
            showPreview(btn);
        };

        $('.document-preview').parent('td').css('cursor', 'default');

        Ext.onReady(function () {
            Ext.QuickTips.init();
            Ext.apply(Ext.QuickTips.getQuickTip(), {
                dismissDelay: 0
            });
        }, {single: true});
    });

})(jQuery);

function spaceAndCommasFormatting(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, " ");
    parts = parts.join(".");
    if (parts.indexOf(".") < 0) {
        parts = parts + ".00";
    }
    return parts.replace(".", ",");
}

function spaceFormatting(x) {
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ");
}