/**
 * Edition variables implementation.
 */
PW.FormActions.create('edition-variables', {

    init: function () {
        this.idsOfArraysVariablesToBlock = this.getIdsOfArraysVariablesToBlock();
        this.variableSets = this.getVariableSetsFromVariables();
        if (this.target.type == "VARIABLESET") {
            if (this.variableSets.length > 1) {
                MessageService.showFailure(CUFCommon.t('edition-variables.variableset.error'));
            }
        }
    },

    variableInit: function (variable) {
        this.variablesToBlock = variable;
    },

    variableSetInit: function (table) {
        this.variablesToBlock = this.get("variables");
    },

    enable: function () {
        this.enableDisableFieldsEditing(this.get("enableEdit"));
        for (let variableSet of this.variableSets) {
            variableSet.editingPlugin.on('beforeedit', this.editingListener, this);
            variableSet.getColumns().filter(col => col.isCheckboxColumn)
                .forEach(checkboxColumn => checkboxColumn.on('beforechange', this.editingListener, this));
        }
    },

    disable: function () {
        this.enableDisableFieldsEditing(!this.get("enableEdit"));
        for (let variableSet of this.variableSets) {
            variableSet.editingPlugin.un('beforeedit', this.editingListener, this);
            variableSet.getColumns().filter(col => col.isCheckboxColumn)
                .forEach(checkboxColumn => checkboxColumn.un('beforechange', this.editingListener, this));
        }
    },

    getVariableSetsFromVariables: function () {
        let variableSets = this.get("variables")
            .filter(variable => variable.isVariableSetVariable)
            .map(variable => variable.getVariableSet().grid);

        return [...new Set(variableSets)];
    },

    getIdsOfArraysVariablesToBlock: function () {
        this.variablesToBlock = this.get("variables");
        var ids = [];
        for (var i = 0; i < this.variablesToBlock.length; i++) {
            ids.push(this.variablesToBlock[i].getId());
        }
        return ids;
    },

    enableDisableFieldsEditing: function (unlock) {
        PW.each(this.variablesToBlock, function (variable) {
            if (!variable.isVariableSetVariable) {
                if (unlock) {
                    variable.enable();
                } else {
                    variable.disable();
                }
            }
        }, this);
    },

    editingListener: function (ce, data) {
        if (jQuery.inArray(data.field, this.idsOfArraysVariablesToBlock) > -1) {
            var condition = true;
            if (this.target.type == "VARIABLESET") {
                this.setContextVariable("currentRow", VariableSetService.getRowIndex(this.variableSets[0], data.record));
                this.setContextVariable("columnId", data.field);
                condition = this.get("contextCondition").call();
            }
            return (this.get("enableEdit") && condition) || (!this.get("enableEdit") && !condition);
        }
    }
});