PW.FormActions.create('checkbox-column', {
	
	variableSetInit : function (table){
		this.table = VariableSetService.get(table.getId());
		this.tableId = table.getId();
	},
    
    enable: function(){
		this.setColumnCellsToFalse();
		let me = this;
		VariableSetService.addRenderer(this.table, function(value, data, column, metaData){
			me.setContextVariable("currentRow", metaData.row);
    		metaData.encode = false;
    		let valueToSetAfterClick = "false";
    		let checked = ' checked>';
    		if (value !== "true") {
    			valueToSetAfterClick = "true";
    			checked = ' >';
    		}
			let editableCheckbox = '<input type="checkbox" onclick="var table = VariableSetService.get(\''
				+ me.tableId + '\'); VariableSetService.setValue(table,' + metaData.row + ',\'' + column
				+ '\', \'' + valueToSetAfterClick + '\');" ' + checked;
    		let uneditableCheckbox = '<div>' + '<input type="checkbox" disabled' + checked + '</div>';
    		return me.get("isEditable") && !window.isHistory ? editableCheckbox : uneditableCheckbox;
    	}, [this.get("column").getId()]);
    },
    
    disable: function() {
		VariableSetService.removeRenderers(this.table, [this.get("column").getId()]);
    },

	setColumnCellsToFalse: function() {
		for (let rowIndex = 0; rowIndex < VariableSetService.getRowsCount(this.table); rowIndex++)
		{
			if (VariableSetService.getValue(this.table, rowIndex, this.get("column").getId()) !== "true" ){
				VariableSetService.setValue(this.table, rowIndex, this.get("column").getId(), "false");
			}
		}
	}

});