PW.FormActions.create("check-oauth-token-expired", {
    defaultActions: {
        button: function (button) {
            const clientName = this.get("clientName");
            const connectionName = this.get("connectionName");
            const windowTarget = this.get("windowTarget");

            if (checkTokenExpired(clientName, connectionName)) {
                const currentDate = new Date();
                const oneDayMillis = 24 * 60 * 60 * 1000;
                currentDate.setTime(currentDate.getTime() + oneDayMillis);
                const expires = "expires=" + currentDate.toUTCString();

                document.cookie = "oauth_connection_name=" + connectionName + ";" + expires + ";path=/";
                document.cookie = "oauth_client_name=" + clientName + ";" + expires + ";path=/";

                if (windowTarget === "popup") {
                    window.open(getAuthUrl(clientName), "", "popup");
                } else {
                    window.open(getAuthUrl(clientName), "_blank");
                }

                return false;
            }

            if (!button.isAcceptanceButton()) {
                MessageService.showSuccess(CUFCommon.t("check-oauth-token-expired.msg.tokenIsValid"));
            }

            return true;
        }
    },
});

function getAuthUrl(clientName) {
    let data;
    jQuery.ajax({
            url: PW.getAbsolutePath("api/oauth/auth/" + clientName),
            success: function (response) {
                data = response;
            },
            error: function (xhr, status, error) {
                console.error("Error:", error);
            },
            async: false
        }
    );

    return data;
}

function checkTokenExpired(clientName, connectionName) {
    let data = false;
    jQuery.ajax({
            dataType: "json",
            url: PW.getAbsolutePath("plugin/com.suncode-cuf-components/oauth/checkTokenExpired/" + clientName + "/" + connectionName),
            success: function (result) {
                data = (result === true);
            },
            async: false
        }
    );

    return data;
}