PW.FormActions.create('accept-task-and-create-new-process', {

    defaultActions: {
        button: function (scope) {
            let isAcceptButton = scope.button.actionName == this.get('actionName');
            this.acceptAndRun(isAcceptButton);
        }
    },

    acceptAndRun: async function (hideValidationMsg) {
        if (isHistory) {
            let jsonObj = await this.acceptActivity()
                .then(jsonObj => {
                    return jsonObj;
                })
                .catch(error => {
                    MessageService.showFailure(error.message);
                });

            if (jsonObj === undefined) {
                return;
            }
            this.createProcess();
        } else {
            FormService.save();
            let acceptConfig = {};
            acceptConfig.actionName = this.get("actionName");
            acceptConfig.directAccept = true;
            acceptConfig.success = this.createProcess;
            acceptConfig.scope = this;
            if (hideValidationMsg) {
                acceptConfig.failure = function () {
                    console.log('Accept failure. Messages will not be displayed from the FormService.accept function.');
                }
            }
            FormService.accept(acceptConfig);
        }
    },

    acceptActivity: async function () {
        return await fetch(this.prepareUrl("ActivityController/acceptActivity"), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                activityId: activityId,
                processId: processId,
                acceptButtonId: this.get('actionName'),
                variableValueMap: {},
                ignoreValidatorsUnderButton: false
            })
        })
            .then(async response => {
                if (!response.ok) {
                    throw new Error(await response.text());
                }
                return response.json();
            })
            .then(jsonObj => {
                if (!(jsonObj && 'total' in jsonObj && Array.isArray(jsonObj.data))) {
                    throw new Error(CUFCommon.t('cuf.common.activity.actions.AcceptActivity.messages.incorrectData'));
                }
                return jsonObj;
            })
            .catch(error => {
                throw new Error(error);
            });
    },

    prepareUrl: function (endpoint) {
        return window.location.origin + PlusWorkflow.getAbsolutePath("/plugin/com.suncode-cuf-components/" + endpoint);
    },

    createProcess: function (form, action) {
        const variables = {}
        this.get("varibalesID").forEach((variableId, index) => {
            variables[variableId] = this.get("values")[index].getValue();
        });

        let config = {
            packageId: this.get("packageId"),
            processDefId: this.get("processDefId"),
            variables: variables
        };

        let openInNewWindow = this.get('openInNewWindow');

        jQuery.ajax({
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(config),
            url: "api/processes/create",
            error: function (jqXHR, textStatus, errorThrown) {
                Logger.error(errorThrown);
            },
            async: false,
        })
            .done(function (data) {
                if (data.activityId != null) {
                    if (openInNewWindow) {
                        window.open("ProcesActivity.do?activityId=" + data.activityId + "&processKey=" + data.processId, '_blank');
                        window.open(JSON.parse(action.response.responseText).forwardUrl, "_self")
                    } else {
                        window.open("ProcesActivity.do?activityId=" + data.activityId + "&processKey=" + data.processId, "_self")
                    }
                }
            })
            .fail(function () {
                CommentService.add(CUFCommon.t('action.accept-task-and-create-new-process.create-new-process.fail'));
                window.location.reload();
            })
    }
});