PW.Functions.register("StorageData.getString", "string", ["string"], function(paramName) {
	var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
	if (!formalParameter.hasOwnProperty(paramName)) {
		ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
		return "";
	}
    return formalParameter[paramName];
});

PW.Functions.register("StorageData.getInteger", "integer", ["string"], function(paramName) {
	var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
	if (!formalParameter.hasOwnProperty(paramName)) {
		ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
		return 0;
	}
    if (!Number.isInteger(formalParameter[paramName])) {
    	throw new Error("Given paramName '" + paramName + "' doesn't refer to Integer value");
    }
    return formalParameter[paramName];
});

PW.Functions.register("StorageData.getFloat", "float", ["string"], function(paramName) {
	var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
	if (!formalParameter.hasOwnProperty(paramName)) {
		ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
		return 0.0;
	}
    if (!isFloat(formalParameter[paramName])) {
    	throw new Error("Given paramName '" + paramName + "' doesn't refer to Float value");
    }
    return formalParameter[paramName];
});

PW.Functions.register("StorageData.getBoolean", "boolean", ["string"], function(paramName) {
	var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
	if (!formalParameter.hasOwnProperty(paramName)) {
		ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
		return null;
	}
    if (!typeof variable === "boolean") {
    	throw new Error("Given paramName '" + paramName + "' doesn't refer to Boolean value");
    }
    return formalParameter[paramName];
});

PW.Functions.register("StorageData.getDate", "date", ["string"], function(paramName) {
	var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
	if (!formalParameter.hasOwnProperty(paramName)) {
		ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
		return null;
	}
    if (!isStringCorrectDateFormat(formalParameter[paramName])) {
    	throw new Error("Given paramName '" + paramName + "' doesn't refer to LocalDate value");
    }
    return createDateFromString(formalParameter[paramName]);
});

PW.Functions.register("StorageData.getDateTime", "datetime", ["string"], function(paramName) {
	var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
	if (!formalParameter.hasOwnProperty(paramName)) {
		ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
		return null;
	}
    if (!isStringCorrectDateTimeFormat(formalParameter[paramName])) {
    	throw new Error("Given paramName '" + paramName + "' doesn't refer to LocalDateTime value");
    }
    return createDateFromString(formalParameter[paramName]);
});

PW.Functions.register("StorageData.getStringArray", "String[]", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (!formalParameter.hasOwnProperty(paramName)) {
    	ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
    	return [];
    }
    if (!Array.isArray(formalParameter[paramName])) {
        throw new Error("Given paramName: '" + paramName + "' doesn't refer to String[] value");
    }
    return formalParameter[paramName];
});

PW.Functions.register("StorageData.getIntegerArray", "integer[]", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (!formalParameter.hasOwnProperty(paramName)) {
        ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
        return [];
    }
    if (!isParameterIntegerArrayValue(formalParameter[paramName])) {
        throw new Error("Given paramName '" + paramName + "' doesn't refer to Integer[] value");
    }
    return formalParameter[paramName];
});
    
PW.Functions.register("StorageData.getFloatArray", "float[]", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (!formalParameter.hasOwnProperty(paramName)) {
        ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
        return [];
    }
    if (!isParameterFloatArrayValue(formalParameter[paramName])) {
        throw new Error("Given paramName '" + paramName + "' doesn't refer to Float[] value");
    }
    return formalParameter[paramName];
});
    
PW.Functions.register("StorageData.getBooleanArray", "boolean[]", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (!formalParameter.hasOwnProperty(paramName)) {
        ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
        return [];
    }
    if (!isParameterBooleanArrayValue(formalParameter[paramName])) {
        throw new Error("Given paramName '" + paramName + "' doesn't refer to Boolean[] value");
    }
    return formalParameter[paramName];
});
    
PW.Functions.register("StorageData.getDateArray", "date[]", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (!formalParameter.hasOwnProperty(paramName)) {
        ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
        return [];
    }
    if (!isParameterDateArrayValue(formalParameter[paramName])) {
        throw new Error("Given paramName '" + paramName + "' doesn't refer to LocalDate[] value");
    }
    return createDateArrayFromString(formalParameter[paramName]);
});
    
PW.Functions.register("StorageData.getDateTimeArray", "datetime[]", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (!formalParameter.hasOwnProperty(paramName)) {
        ServerLogger.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
        return [];
    }
    if (!isParameterDateTimeArrayValue(formalParameter[paramName])) {
        throw new Error("Given paramName '" + paramName + "' doesn't refer to LocalDateTime[] value");
    }
    return createDateArrayFromString(formalParameter[paramName]);
});

PW.Functions.register("StorageData.exist", "boolean", ["string"], function(paramName) {
    var formalParameter = JSON.parse(VariableService.getValue("StorageData"));
    if (formalParameter.hasOwnProperty(paramName)) {
        return true;
    }
    return false;

});
   
function isFloat(n) {
    return Number(n) === n && n % 1 !== 0;
}

function isStringCorrectDateFormat(date) {
	var re = /^\d{4}-(0[1-9]|1[0-2])-([0-2]\d|3[01])/;
	if(re.test(date)) {
		return true;
	}
	return false;
}

function createDateFromString(date) {
	if (!date) {
		return null;
	}
	var year = parseInt(date.substring(0,4));
	var month = parseInt(date.substring(5,7));
	var day = parseInt(date.substring(8,10));
	var hour = 0;
	var minute = 0;
	var second = 0;
	if (date.length > 10 ){
		hour = parseInt(date.substring(11,13));
		minute = parseInt(date.substring(14,16));
		second = parseInt(date.substring(17,19));
	}	
	return new Date(year, month - 1, day, hour, minute, second);
}

function createDateArrayFromString(dates) {
	var dateArray = [];
	PW.each(dates, function(date){
		dateArray.push(createDateFromString(date));
	});
	return dateArray;
}

function isStringCorrectDateTimeFormat(date) {
	var re = /^\d{4}-(0[1-9]|1[0-2])-([0-2]\d|3[01]) ([01]\d|2[0-3]):[0-5]\d:[0-5]\d$/;
	if (re.test(date)) {
		return true;
	}
	return false;
}

function isParameterIntegerArrayValue(integerValues) {
    if (!Array.isArray(integerValues)) {
        return false;
    }
    PW.each(integerValues, function(value) {
    	if (!Number.isInteger(value)) {
    		return false;
    	}
    });
    return true;
}

function isParameterFloatArrayValue(floatValues) {
    if (!Array.isArray(floatValues))
    {
        return false;
    }
    PW.each(floatValues, function(value) {
    	if (!isFloat(value)){
    		return false;
    	}
    });
    return true;
}

function isParameterBooleanArrayValue(booleanValues) {
    if (!Array.isArray(booleanValues)) {
        return false;
    }
    PW.each(booleanValues, function(value) {
    	if (!typeof value === "boolean") {
    		return false;
    	}
    });
    return true;
}

function isParameterDateArrayValue(dateValues) {
    if (!Array.isArray(dateValues)) {
        return false;
    }
    PW.each(dateValues, function(value){
    	if (!isStringCorrectDateFormat(value) && value != null) {
    		return false;
    	}
    });
    return true;
}

function isParameterDateTimeArrayValue(dateTimeValues) {
    if (!Array.isArray(dateTimeValues)) {
        return false;
    }
    PW.each(dateTimeValues, function(value){
    	if (!isStringCorrectDateTimeFormat(value) && value != null) {
    		return false;
    	}
    });
    return true;
}
