PW.Functions.register("ibanFormat", "string", ["string"], function (input) {
    input = input.toString();

    if (input.length === 0)
        return input;

    let isLetterRegexp = new RegExp("^\\p{L}", "u");

    if (isLetterRegexp.test(input.charAt(0)) && isLetterRegexp.test(input.charAt(1))) {
        return maskFormat("####-####-####-####-####-####-####-####-####-####", input);
    } else {
        return maskFormat("##-####-####-####-####-####-####-####-####-####", input);
    }
});

function maskFormat(mask, input) {
    mask = mask.toString();
    input = input.toString();

    if (mask.length === 0 || input.length === 0 || input.length > mask.replace("-", "").length)
        return input;

    let maskChar = '#';
    let spaceChar = '-';
    let formattedValue = '';
    let inputCharPosition = 0;

    for (let i = 0; i < mask.length; i++) {
        if (input.length <= inputCharPosition) {
            break;
        }

        if (mask.charAt(i) === maskChar) {
            formattedValue += input.charAt(inputCharPosition++);
        } else if (mask.charAt(i) === spaceChar) {
            formattedValue += ' ';
        }
    }

    return formattedValue;
}