/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.cuf.common.db.dto.VariableInfoDto;
import com.suncode.cuf.common.db.schemas.ProcessingDataDefinition;
import com.suncode.cuf.common.utils.ProcessedData;
import com.suncode.pwfl.workflow.form.datachooser.automapping.AutoMappingExecutor;
import com.suncode.pwfl.workflow.form.datachooser.automapping.AutoMappingExecutorConfig;
import com.suncode.pwfl.workflow.form.datachooser.automapping.AutoMappingTaskResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessingDataService {
    private static final String INTERNAL_ID_KEY = "internalId";
    private Cache<String, Map<Integer, Map<String, Object>>> dataCache = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.MINUTES).build();
    @Autowired
    private AutoMappingExecutor autoMappingExecutor;

    public void cacheData(String uuid, List<Map<String, Object>> data) {
        Map<Integer, Map<String, Object>> evaluatedData = this.applyUniqueIndex(data, this.getStartIndex(uuid));
        this.cacheData(uuid, evaluatedData);
    }

    private Map<Integer, Map<String, Object>> applyUniqueIndex(List<Map<String, Object>> data, int start) {
        for (int i = 0; i < data.size(); ++i) {
            data.get(i).put(INTERNAL_ID_KEY, i + start);
        }
        return data.stream().collect(Collectors.toMap(entry -> (Integer)entry.get(INTERNAL_ID_KEY), entry -> entry));
    }

    private int getStartIndex(String uuid) {
        int start = 0;
        Map data = (Map)this.dataCache.getIfPresent((Object)uuid);
        if (data == null) {
            return start;
        }
        return data.size();
    }

    private void cacheData(String uuid, Map<Integer, Map<String, Object>> data) {
        HashMap<Integer, Map<String, Object>> cached = (HashMap<Integer, Map<String, Object>>)this.dataCache.getIfPresent((Object)uuid);
        if (cached == null) {
            cached = new HashMap<Integer, Map<String, Object>>();
        }
        cached.putAll(data);
        this.dataCache.put((Object)uuid, cached);
    }

    public ProcessedData processData(String uuid, ProcessingDataDefinition definition) {
        Map data = (Map)this.dataCache.getIfPresent((Object)uuid);
        if (data == null) {
            return null;
        }
        ArrayList<Map<String, Object>> filteredData = new ArrayList<Map<String, Object>>();
        definition.getIds().forEach(id -> filteredData.add((Map)data.get(id)));
        if (definition.isExecuteAutomapping()) {
            AutoMappingTaskResult autoMappingResult = this.applyDataChoosersMappings(filteredData, definition);
            return ProcessedData.builder().data(autoMappingResult.getData()).mappedVariablesByDataChoosers(autoMappingResult.getMappedVariables()).build();
        }
        return ProcessedData.builder().data(filteredData).mappedVariablesByDataChoosers(Collections.emptySet()).build();
    }

    public void invalidate(String uuid) {
        this.dataCache.invalidate((Object)uuid);
    }

    private AutoMappingTaskResult applyDataChoosersMappings(List<Map<String, Object>> data, ProcessingDataDefinition definition) {
        if (StringUtils.isBlank((String)definition.getProcessId()) || StringUtils.isBlank((String)definition.getActivityId()) || CollectionUtils.isEmpty(data)) {
            return new AutoMappingTaskResult(data);
        }
        Set columnsToSet = definition.getVariables().stream().filter(VariableInfoDto::getIsArray).map(VariableInfoDto::getId).collect(Collectors.toSet());
        AutoMappingExecutorConfig config = new AutoMappingExecutorConfig(data, definition.getProcessId(), definition.getActivityId());
        config.setOverrideCurrentGridValues(definition.isOverwrite());
        config.setColumnsToProcess(columnsToSet);
        return this.autoMappingExecutor.applyDataChoosersAutoMappings(config);
    }
}

