/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils;

import com.suncode.cuf.common.general.VariableDto;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.time.LocalDate;

public class CommonUtils {
    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean isEmptyArray(Object[] array, Type<?> type) {
        if (array == null || array.length == 0) {
            return true;
        }
        if (array.length == 1) {
            return array[0] == null || type == Types.STRING_ARRAY && array[0].equals("");
        }
        return false;
    }

    public static Object[] createTableOfType(int size, Type<?> type) {
        if (type == Types.STRING_ARRAY) {
            return new String[size];
        }
        if (type == Types.INTEGER_ARRAY) {
            return new Long[size];
        }
        if (type == Types.FLOAT_ARRAY) {
            return new Double[size];
        }
        if (type == Types.DATE_ARRAY) {
            return new LocalDate[size];
        }
        throw new IllegalArgumentException("Unsupported type! " + type.name());
    }

    public static boolean isColumnEmpty(Object[] array) {
        return array == null || array.length == 0 || array.length == 1 && (array[0] == null || array[0] instanceof String && array[0].equals(""));
    }

    public static VariableDto[] getExcludingVariables(Variable[] excludingVariables, String[] excludingValues) {
        return (VariableDto[])IntStream.range(0, excludingVariables.length).mapToObj(index -> new VariableDto(excludingVariables[index].getId(), excludingValues[index], String.valueOf(excludingVariables[index].getBasicType()))).toArray(VariableDto[]::new);
    }

    public static VariableDto[] convertVariableArrayToVariableDtoArray(Variable[] variableArray) {
        return (VariableDto[])Stream.of(variableArray).map(variable -> new VariableDto(variable.getId(), String.valueOf(variable.getValueAsBasicType()), String.valueOf(variable.getBasicType()))).toArray(VariableDto[]::new);
    }
}

