/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.substitutes;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubstitutedUsersDataFinder {
    @Autowired
    private SubstitutionService substitutionService;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private PositionFinder positionFinder;

    public List<User> findSubstitutedUsers(String substituteUsername, boolean deep) {
        ArrayList<User> users = new ArrayList<User>();
        return this.findSubstitutedUsersInternal(users, substituteUsername, deep).stream().distinct().collect(Collectors.toList());
    }

    private List<User> findSubstitutedUsersInternal(List<User> resultUserList, String username, boolean deep) {
        List substitutions = this.substitutionService.getSubstitutionsForSubstitute(username);
        for (Substitution substitution : substitutions) {
            User substitutedUser = this.userFinder.findByUserName(substitution.getSubstituted().getUserName(), new String[]{"positions"});
            Set<Position> positionsWithHigherPositions = this.getPositionsWithHigherPositions(substitutedUser);
            this.addPositionsToUser(substitutedUser, positionsWithHigherPositions);
            resultUserList.add(substitutedUser);
            if (!deep) continue;
            this.findSubstitutedUsersInternal(resultUserList, substitutedUser.getUserName(), true);
        }
        return resultUserList;
    }

    public User getSingleUserData(String username) {
        User user = this.userFinder.findByUserName(username, new String[]{"positions"});
        Set<Position> positionsWithHigherPositions = this.getPositionsWithHigherPositions(user);
        this.addPositionsToUser(user, positionsWithHigherPositions);
        return user;
    }

    private void addPositionsToUser(User substitutedUser, Set<Position> positionsWithHigherPositions) {
        Set positions = substitutedUser.getPositions();
        positions.clear();
        for (Position position : positionsWithHigherPositions) {
            positions.add(position);
        }
    }

    private Set<Position> getPositionsWithHigherPositions(User user) {
        HashSet<Position> positionsWithHigherPositions = new HashSet<Position>();
        for (Position position : user.getPositions()) {
            Position positionWithHigherPosition = this.positionFinder.getPosition(position.getId(), new String[]{"higherPosition"});
            Position higherPosition = positionWithHigherPosition.getHigherPosition();
            if (null != higherPosition) {
                higherPosition = this.positionFinder.getPosition(higherPosition.getId(), new String[]{"user"});
                positionWithHigherPosition.setHigherPosition(higherPosition);
            }
            positionsWithHigherPositions.add(positionWithHigherPosition);
        }
        return positionsWithHigherPositions;
    }
}

