/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Application
@ComponentsFormScript(value="scripts/dynamic-pwe/organizational-unit-data-form.js")
public class OrganizationalUnitDataApplication {
    private static final Logger log = LoggerFactory.getLogger(OrganizationalUnitDataApplication.class);
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private OrganizationalUnitFinder ouFinder;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("organizational-unit-data")).name("application.organizational-unit-data.name")).description("application.organizational-unit-data.desc")).category(new Category[]{Categories.USER})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}get-organizational-unit-data-application")).icon((Icon)SilkIconPack.USER)).parameter().id("symbol").name("application.organizational-unit-data.symbol.name").type((Type)Types.STRING).create()).parameter().id("data").name("application.organizational-unit-data.data.name").description("application.organizational-unit-data.data.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("variablesToSave").name("application.organizational-unit-data.variables-to-save.name").description("application.organizational-unit-data.variables-to-save.desc").type((Type)Types.VARIABLE_ARRAY).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap activityContextMap, @Param String symbol, @Param String[] data, @Param Variable[] variablesToSave, Translator translator) throws IllegalArgumentException {
        log.trace("*** OrganizationalUnitData application ***");
        OrganizationalUnit ou = this.ouFinder.findBySymbol(symbol, new String[0]);
        if (ou == null) {
            log.error("No organizational unit with given symbol found");
            throw new IllegalArgumentException("No organizational unit with given symbol found");
        }
        for (int i = 0; i < data.length; ++i) {
            try {
                variablesToSave[i].setValue(this.getValue(symbol, data[i], variablesToSave[i].isArray()));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private Object getValue(String symbol, String dataType, boolean isArray) {
        OUDataType ouDataType = OUDataType.valueOf(dataType.toUpperCase());
        switch (ouDataType) {
            case USERS: {
                List usersList = this.userFinder.findByOU(symbol);
                ArrayList<String> usersNames = new ArrayList<String>();
                for (User user : usersList) {
                    usersNames.add(user.getUserName());
                }
                if (isArray) {
                    return usersNames.toArray(new String[usersNames.size()]);
                }
                return StringUtils.collectionToDelimitedString(usersNames, (String)";");
            }
            case NAME: {
                this.checkArray(isArray);
                return this.ouFinder.findBySymbol(symbol, new String[0]).getName();
            }
            case HIGHEROUSYMBOL: {
                this.checkArray(isArray);
                OrganizationalUnit ou = this.ouFinder.findBySymbol(symbol, new String[]{"higherOrganizationalUnit"});
                OrganizationalUnit higherOu = ou.getHigherOrganizationalUnit();
                if (higherOu != null) {
                    return higherOu.getSymbol();
                }
                return null;
            }
            case SUBOUSYMBOL: {
                OrganizationalUnit ouWithSub = this.ouFinder.findBySymbol(symbol, new String[]{"subOus"});
                Set subOu = ouWithSub.getSubOus();
                CharSequence[] subOuSymbols = subOu == null ? new String[]{} : (String[])subOu.stream().map(OrganizationalUnit::getSymbol).toArray(String[]::new);
                return isArray ? subOuSymbols : String.join((CharSequence)";", subOuSymbols);
            }
            case SUBUSERS: {
                OrganizationalUnit subUsers = this.ouFinder.findBySymbol(symbol, new String[]{"subOus"});
                Set usersSubOu = subUsers.getSubOus();
                HashSet<String> subUsersNames = new HashSet<String>();
                for (OrganizationalUnit unit : usersSubOu) {
                    List subUsersList = this.userFinder.findByOU(unit.getSymbol());
                    for (User subUser : subUsersList) {
                        subUsersNames.add(subUser.getUserName());
                    }
                }
                if (isArray) {
                    return subUsersNames.toArray(new String[subUsersNames.size()]);
                }
                return StringUtils.collectionToDelimitedString(subUsersNames, (String)";");
            }
            case ALLUSERS: {
                OrganizationalUnit subUsers2 = this.ouFinder.findBySymbol(symbol, new String[]{"subOus"});
                Set usersSubOu2 = subUsers2.getSubOus();
                HashSet<String> allUsersNames = new HashSet<String>();
                for (OrganizationalUnit unit : usersSubOu2) {
                    List subUsersList2 = this.userFinder.findByOU(unit.getSymbol());
                    for (User subUser : subUsersList2) {
                        allUsersNames.add(subUser.getUserName());
                    }
                }
                List usersList2 = this.userFinder.findByOU(symbol);
                for (User user : usersList2) {
                    allUsersNames.add(user.getUserName());
                }
                if (isArray) {
                    return allUsersNames.toArray(new String[allUsersNames.size()]);
                }
                return StringUtils.collectionToDelimitedString(allUsersNames, (String)";");
            }
        }
        throw new IllegalArgumentException("Invalid application parameter 'data'");
    }

    private void checkArray(boolean isArray) {
        if (isArray) {
            throw new IllegalArgumentException("Invalid type - cannot save to array variable");
        }
    }

    public static enum OUDataType {
        USERS,
        NAME,
        HIGHEROUSYMBOL,
        SUBOUSYMBOL,
        SUBUSERS,
        ALLUSERS;

    }
}

