/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.functions;

import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Functions
@FunctionsScript(value="/functions/regex-functions.js")
public class RegexFunctions {
    @Function(value="Regex.match")
    public String[] regexMatch(String regex, String text) {
        return this.processRegex(regex, text, false);
    }

    @Function(value="Regex.group")
    public String[] regexGroup(String regex, String text) {
        return this.processRegex(regex, text, true);
    }

    private String[] processRegex(String regex, String text, boolean includeGroups) {
        if (StringUtils.isEmpty((CharSequence)regex)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> results = new ArrayList<String>();
        while (matcher.find()) {
            if (includeGroups) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    results.add(matcher.group(i));
                }
                continue;
            }
            results.add(matcher.group(0));
        }
        return results.toArray(new String[0]);
    }
}

