/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.functions;

import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;

@Functions
@FunctionsScript(value="/functions/date-functions.js")
public class DateFunctions {
    private List<LocalDate> customHolidays = new ArrayList<LocalDate>();
    @Autowired
    private SystemParameterService systemParameterService;

    @Function
    public int calculateDaysDifference(LocalDate firstDate, LocalDate secondDate, Boolean includeFreeDays) {
        if (firstDate == null || secondDate == null) {
            return 0;
        }
        LocalDate earlierDate = this.getEarlierDate(firstDate, secondDate);
        LocalDate laterDate = this.getLaterDate(firstDate, secondDate);
        this.loadSystemCustomHolidays();
        int dayDifference = 0;
        int absoluteDayDifference = (int)((laterDate.toDate().getTime() - earlierDate.toDate().getTime()) / 86400000L);
        if (!includeFreeDays.booleanValue()) {
            for (int i = 0; i <= absoluteDayDifference; ++i) {
                LocalDate dayInCheck = earlierDate.plusDays(i);
                if (this.isHolidayOrWeekend(dayInCheck)) continue;
                ++dayDifference;
            }
        } else {
            dayDifference = absoluteDayDifference + 1;
        }
        return dayDifference;
    }

    @Function
    public int calculateTimeDifference(LocalDateTime firstDate, LocalDateTime secondDate, Boolean includeFreeDays, Boolean timeShift, String returnType) {
        if (firstDate == null || secondDate == null) {
            return 0;
        }
        LocalDateTime earlierDateTime = this.getEarlierDateTime(firstDate, secondDate);
        LocalDateTime laterDateTime = this.getLaterDateTime(firstDate, secondDate);
        this.loadSystemCustomHolidays();
        long differenceDay = Math.round((double)(laterDateTime.toDateTime().getMillis() - earlierDateTime.toDateTime().getMillis()) / 8.64E7);
        long nonWorkingDays = 0L;
        Boolean firstDayOff = false;
        Boolean lastDayOff = false;
        if (!includeFreeDays.booleanValue()) {
            int i = 0;
            while ((long)i <= differenceDay) {
                LocalDateTime dayInCheck = earlierDateTime.plusDays(i);
                if (this.isHolidayOrWeekend(dayInCheck.toLocalDate())) {
                    if (i == 0) {
                        firstDayOff = true;
                    } else if ((long)i == differenceDay) {
                        lastDayOff = true;
                    } else {
                        ++nonWorkingDays;
                    }
                }
                ++i;
            }
        }
        long millis = laterDateTime.toDateTime().getMillis() - this.calcNonWorkingTime(nonWorkingDays, earlierDateTime, laterDateTime, firstDayOff, lastDayOff);
        LocalDateTime tempDate = new LocalDateTime(millis);
        long durationMillis = tempDate.toDateTime().getMillis() - earlierDateTime.toDateTime().getMillis();
        if (!timeShift.booleanValue() || !includeFreeDays.booleanValue()) {
            DateTimeZone tz = DateTimeZone.getDefault();
            int tempDateOffset = tz.getOffset(laterDateTime.toDateTime().getMillis());
            int earlierDateTimeOffset = tz.getOffset(earlierDateTime.toDateTime().getMillis());
            durationMillis += (long)(tempDateOffset - earlierDateTimeOffset);
        }
        if (durationMillis < 0L) {
            return 0;
        }
        int yearDifference = tempDate.getYear() - earlierDateTime.getYear();
        switch (returnType) {
            case "SECOND": {
                return (int)(durationMillis / 1000L);
            }
            case "MINUTE": {
                return (int)(durationMillis / 60000L);
            }
            case "HOUR": {
                return (int)(durationMillis / 3600000L);
            }
            case "DAY": {
                return (int)(durationMillis / 86400000L);
            }
            case "WEEK": {
                return (int)(durationMillis / 604800000L);
            }
            case "MONTH": {
                int monthDifference = tempDate.getMonthOfYear() - earlierDateTime.getMonthOfYear();
                return yearDifference * 12 + monthDifference + this.getMonthCorrection(laterDateTime, earlierDateTime);
            }
            case "YEAR": {
                return yearDifference + this.getYearCorrection(laterDateTime, earlierDateTime);
            }
        }
        return 0;
    }

    @Function
    public LocalDate calcDateWorkingDays(LocalDate date, int workingDays) {
        boolean subtractionDaysFromDate;
        if (workingDays == 0) {
            return date;
        }
        this.loadSystemCustomHolidays();
        boolean bl = subtractionDaysFromDate = workingDays < 0;
        if (!subtractionDaysFromDate) {
            if (this.isHolidayOrWeekend(date)) {
                date = this.setDateAtFirstWorkingDay(date);
            }
            int nextDay = 1;
            int totalWorkingDays = workingDays;
            int holidaysAndWorkingDays = workingDays;
            while (totalWorkingDays > 0) {
                LocalDate checkDayInDate = date.plusDays(nextDay);
                if (this.isHolidayOrWeekend(checkDayInDate)) {
                    ++holidaysAndWorkingDays;
                    ++nextDay;
                    continue;
                }
                --totalWorkingDays;
                ++nextDay;
            }
            return date.withFieldAdded(DurationFieldType.days(), holidaysAndWorkingDays);
        }
        if (this.isHolidayOrWeekend(date)) {
            date = this.setDateAtFirstPastWorkingDay(date);
        }
        int nextDay = -1;
        int totalWorkingDays = workingDays;
        int holidaysAndWorkingDays = workingDays;
        while (totalWorkingDays < 0) {
            LocalDate checkDayInDate = date.plusDays(nextDay);
            if (this.isHolidayOrWeekend(checkDayInDate)) {
                --holidaysAndWorkingDays;
                --nextDay;
                continue;
            }
            ++totalWorkingDays;
            --nextDay;
        }
        return date.withFieldAdded(DurationFieldType.days(), holidaysAndWorkingDays);
    }

    @Function
    public LocalDateTime calcDateWorkingDays(LocalDateTime dateTime, int workingDays) {
        if (workingDays == 0) {
            return dateTime;
        }
        LocalDate localDate = this.calcDateWorkingDays(dateTime.toLocalDate(), workingDays);
        return localDate.toLocalDateTime(dateTime.toLocalTime());
    }

    @Function
    public LocalDate nextWorkingDay(LocalDate date) {
        this.loadSystemCustomHolidays();
        LocalDate startingDate = date.plusDays(1);
        return this.setDateAtFirstWorkingDay(startingDate);
    }

    @Function
    public LocalDateTime nextWorkingDay(LocalDateTime dateTime) {
        LocalDate localDate = this.nextWorkingDay(dateTime.toLocalDate());
        return localDate.toLocalDateTime(dateTime.toLocalTime());
    }

    @Function
    public LocalDate previousWorkingDay(LocalDate date) {
        this.loadSystemCustomHolidays();
        LocalDate startingDate = date.minusDays(1);
        return this.setDateAtFirstPastWorkingDay(startingDate);
    }

    @Function
    public LocalDateTime previousWorkingDay(LocalDateTime dateTime) {
        LocalDate localDate = this.previousWorkingDay(dateTime.toLocalDate());
        return localDate.toLocalDateTime(dateTime.toLocalTime());
    }

    private LocalDate setDateAtFirstWorkingDay(LocalDate date) {
        int i = 0;
        LocalDate checkDayInDate = date;
        while (this.isHolidayOrWeekend(checkDayInDate)) {
            checkDayInDate = date.plusDays(++i);
        }
        return checkDayInDate;
    }

    private LocalDate setDateAtFirstPastWorkingDay(LocalDate date) {
        int i = 0;
        LocalDate checkDayInDate = date;
        while (this.isHolidayOrWeekend(checkDayInDate)) {
            checkDayInDate = date.plusDays(--i);
        }
        return checkDayInDate;
    }

    private long calcNonWorkingTime(long nonWorkingDays, LocalDateTime earlierDate, LocalDateTime laterDate, Boolean firstDayOff, Boolean lastDayOff) {
        long nonWorkingTime = nonWorkingDays * 86400000L;
        if (firstDayOff.booleanValue()) {
            nonWorkingTime += (long)(86400000 - this.milsOfTime(earlierDate));
        }
        if (lastDayOff.booleanValue()) {
            nonWorkingTime += (long)this.milsOfTime(laterDate);
        }
        return nonWorkingTime;
    }

    private int getYearCorrection(LocalDateTime laterDate, LocalDateTime earlierDate) {
        if (laterDate.getMonthOfYear() == earlierDate.getMonthOfYear()) {
            return this.getMonthCorrection(laterDate, earlierDate);
        }
        if (laterDate.getMonthOfYear() > earlierDate.getMonthOfYear()) {
            return 0;
        }
        return -1;
    }

    private int getMonthCorrection(LocalDateTime laterDate, LocalDateTime earlierDate) {
        if (laterDate.getDayOfMonth() == earlierDate.getDayOfMonth()) {
            return this.getTimeCorrection(laterDate, earlierDate);
        }
        if (laterDate.getDayOfMonth() > earlierDate.getDayOfMonth()) {
            return 0;
        }
        return -1;
    }

    private int getTimeCorrection(LocalDateTime laterDate, LocalDateTime earlierDate) {
        return this.milsOfTime(laterDate) < this.milsOfTime(earlierDate) ? -1 : 0;
    }

    private int milsOfTime(LocalDateTime date) {
        return date.getHourOfDay() * 3600000 + date.getMinuteOfHour() * 60000 + date.getSecondOfMinute() * 1000;
    }

    private void loadSystemCustomHolidays() {
        this.customHolidays = new ArrayList<LocalDate>();
        LocalDate tempDate = null;
        SystemParameter systemCustomHolidays = this.systemParameterService.getParameter("CustomHolidays");
        if (systemCustomHolidays != null && systemCustomHolidays.getValueString() != null) {
            String[] customHolidays;
            for (String freeCustomDay : customHolidays = systemCustomHolidays.getValueString().split(";")) {
                if (StringUtils.isBlank((CharSequence)freeCustomDay)) continue;
                if (freeCustomDay.length() == 5) {
                    tempDate = new LocalDate((Object)(Integer.toString(new LocalDate().getYear()) + "-" + freeCustomDay));
                } else {
                    if (freeCustomDay.length() != 10) continue;
                    tempDate = new LocalDate((Object)freeCustomDay);
                }
                this.customHolidays.add(tempDate);
            }
        }
    }

    private LocalDate getEarlierDate(LocalDate firstDate, LocalDate secondDate) {
        if (firstDate.isBefore((ReadablePartial)secondDate)) {
            return firstDate;
        }
        return secondDate;
    }

    private LocalDateTime getEarlierDateTime(LocalDateTime firstDateTime, LocalDateTime secondDateTime) {
        if (firstDateTime.isBefore((ReadablePartial)secondDateTime)) {
            return firstDateTime;
        }
        return secondDateTime;
    }

    private LocalDate getLaterDate(LocalDate firstDate, LocalDate secondDate) {
        if (firstDate.isAfter((ReadablePartial)secondDate)) {
            return firstDate;
        }
        return secondDate;
    }

    private LocalDateTime getLaterDateTime(LocalDateTime firstDateTime, LocalDateTime secondDateTime) {
        if (firstDateTime.isAfter((ReadablePartial)secondDateTime)) {
            return firstDateTime;
        }
        return secondDateTime;
    }

    private boolean isHolidayOrWeekend(LocalDate dayInCheck) {
        if (this.customHolidays.contains(dayInCheck)) {
            return true;
        }
        if (this.belongsToWeekend(dayInCheck) || this.isStaticHoliday(dayInCheck)) {
            return true;
        }
        if (dayInCheck.getMonthOfYear() >= 3 || dayInCheck.getMonthOfYear() <= 6) {
            return this.isMovingHoliday(dayInCheck);
        }
        return false;
    }

    private boolean belongsToWeekend(LocalDate dayInCheck) {
        return dayInCheck.getDayOfWeek() == 6 || dayInCheck.getDayOfWeek() == 7;
    }

    private boolean isStaticHoliday(LocalDate dayInCheck) {
        switch (dayInCheck.getMonthOfYear()) {
            case 1: {
                if (dayInCheck.getDayOfMonth() != 1 && dayInCheck.getDayOfMonth() != 6) break;
                return true;
            }
            case 5: {
                if (dayInCheck.getDayOfMonth() != 1 && dayInCheck.getDayOfMonth() != 3) break;
                return true;
            }
            case 8: {
                if (dayInCheck.getDayOfMonth() != 15) break;
                return true;
            }
            case 11: {
                if (dayInCheck.getDayOfMonth() != 1 && dayInCheck.getDayOfMonth() != 11) break;
                return true;
            }
            case 12: {
                if (dayInCheck.getDayOfMonth() != 25 && dayInCheck.getDayOfMonth() != 26) break;
                return true;
            }
        }
        return false;
    }

    private boolean isMovingHoliday(LocalDate dayInCheck) {
        int a = dayInCheck.getYear() % 19;
        int b = (int)Math.floor(dayInCheck.getYear() / 100);
        int c = dayInCheck.getYear() % 100;
        int d = (int)Math.floor(b / 4);
        int e = b % 4;
        int f = (int)Math.floor((b + 8) / 25);
        int g = (int)Math.floor((b - f + 1) / 3);
        int h = (19 * a + b - d - g + 15) % 30;
        int i = (int)Math.floor(c / 4);
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (int)Math.floor((a + 11 * h + 22 * l) / 451);
        int p = (h + l - 7 * m + 114) % 31;
        int day = p + 1;
        int month = (int)Math.floor((h + l - 7 * m + 114) / 31);
        LocalDate easterFirst = new LocalDate(dayInCheck.getYear(), month, day);
        LocalDate easterSecond = new LocalDate((Object)easterFirst.plusDays(1));
        LocalDate ZDS = easterFirst.plusDays(49);
        LocalDate BC = easterFirst.plusDays(60);
        return dayInCheck.equals((Object)easterFirst) || dayInCheck.equals((Object)easterSecond) || dayInCheck.equals((Object)ZDS) || dayInCheck.equals((Object)BC);
    }
}

