/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.validators;

import com.suncode.cuf.archive.verification.ConditionType;
import com.suncode.cuf.archive.verification.DocumentVerifier;
import com.suncode.cuf.archive.verification.VerificationMode;
import com.suncode.cuf.archive.verification.internal.condition.EQCondition;
import com.suncode.cuf.archive.verification.internal.condition.GECondition;
import com.suncode.cuf.archive.verification.internal.condition.GTCondition;
import com.suncode.cuf.archive.verification.internal.condition.LECondition;
import com.suncode.cuf.archive.verification.internal.condition.LTCondition;
import com.suncode.cuf.archive.verification.internal.condition.NOTEQCondition;
import com.suncode.cuf.archive.verification.internal.mode.ActivityVerificationMode;
import com.suncode.cuf.archive.verification.internal.mode.ProcessVerificationMode;
import com.suncode.cuf.archive.verification.internal.mode.StageVerificationMode;
import com.suncode.cuf.archive.verification.model.VerificationCondition;
import com.suncode.cuf.archive.verification.model.VerificationDefinition;
import com.suncode.cuf.archive.verification.model.VerificationResult;
import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@ComponentsFormScript(value="scripts/dynamic-pwe/verify-documents-form.js")
@Validator
public class VerifyDocuments {
    private static final Logger log = LoggerFactory.getLogger(VerifyDocuments.class);
    @Autowired
    private DocumentVerifier verifier;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("verify-documents")).name("validator.verify-documents.name")).description("validator.verify-documents.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}verification-of-process-documents")).icon((Icon)DivanteIcon.CHECK_CIRCLE)).parameter().id("verificationMode").name("validator.verify-documents.verify-mode.name").description("validator.verify-documents.verify-mode.desc").type((Type)Types.STRING).defaultValue((Object)"activity").create()).parameter().id("documentClassName").name("validator.verify-documents.documentClassName.name").description("validator.verify-documents.documentClassName.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("documentCount").name("validator.verify-documents.documentCount.name").description("validator.verify-documents.documentCount.desc").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("conditionType").name("validator.verify-documents.conditionType.name").description("validator.verify-documents.conditionType.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("fileNameRegExp").name("validator.verify-documents.fileNameRegExp.name").description("validator.verify-documents.fileNameRegExp.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("conditionalOperator").name("validator.verify-documents.conditionOperator.name").description("validator.verify-documents.conditionOperator.desc").type((Type)Types.STRING).defaultValue((Object)"AND").create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void validate(@Param String verificationMode, @Param String[] documentClassName, @Param Long[] documentCount, @Param String[] conditionType, @Param String[] fileNameRegExp, @Param String conditionalOperator, @Param Boolean confirmation, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean hasValidationErrors = false;
        if (conditionalOperator.equals("AND")) {
            for (i = 0; i < documentClassName.length; ++i) {
                validationResult = this.validateDocuments(verificationMode, new String[]{documentClassName[i]}, new Long[]{documentCount[i]}, new String[]{conditionType[i]}, new String[]{fileNameRegExp[i]}, validationContext, translator);
                if (validationResult.isValid()) continue;
                hasValidationErrors = true;
                stringBuilder.append(this.formatValidationItem(documentClassName[i], documentCount[i], conditionType[i], validationResult, translator));
            }
        } else if (conditionalOperator.equals("OR")) {
            for (i = 0; i < documentClassName.length; ++i) {
                validationResult = this.validateDocuments(verificationMode, new String[]{documentClassName[i]}, new Long[]{documentCount[i]}, new String[]{conditionType[i]}, new String[]{fileNameRegExp[i]}, validationContext, translator);
                if (validationResult.isValid()) {
                    stringBuilder = new StringBuilder();
                    hasValidationErrors = false;
                    break;
                }
                hasValidationErrors = true;
                stringBuilder.append(this.formatValidationItem(documentClassName[i], documentCount[i], conditionType[i], validationResult, translator));
            }
        } else {
            throw new IllegalArgumentException(translator.getMessage("validator.verify-documents.operator.conditional.unknown"));
        }
        if (hasValidationErrors) {
            String headerKey = conditionalOperator.equals("AND") ? "validator.verify-documents.conditions.all" : "validator.verify-documents.conditions.any";
            StringBuilder finalMessage = new StringBuilder();
            finalMessage.append("<p>").append(translator.getMessage(headerKey)).append("</p><ul>").append((CharSequence)stringBuilder).append("</ul>");
            if (Boolean.TRUE.equals(confirmation)) {
                finalMessage.append(" ");
                finalMessage.append(translator.getMessage("validator.confirmation.question"));
                errors.addConfirmation(finalMessage.toString(), translator.getMessage("validator.title_default"));
            } else {
                errors.add(finalMessage.toString());
            }
        }
    }

    private VerificationResult validateDocuments(String verificationMode, String[] documentClassName, Long[] documentCount, String[] conditionType, String[] fileNameRegExp, ValidationContext validationContext, Translator translator) {
        VerificationDefinition verificationDefinition = new VerificationDefinition();
        verificationDefinition.setProcessId(validationContext.getProcessId());
        verificationDefinition.setActivityId(validationContext.getActivityId());
        verificationDefinition.setMode(this.establishMode(verificationMode, translator));
        List<VerificationCondition> verificationConditions = this.formVerificationConditions(documentClassName, documentCount, conditionType, fileNameRegExp, translator);
        verificationDefinition.setConditions(verificationConditions);
        return this.verifier.verifyDocuments(verificationDefinition);
    }

    private List<VerificationCondition> formVerificationConditions(String[] documentClassName, Long[] documentCount, String[] conditionType, String[] fileNameRegExp, Translator translator) {
        ArrayList<VerificationCondition> verificationConditions = new ArrayList<VerificationCondition>();
        for (int i = 0; i < documentClassName.length; ++i) {
            VerificationCondition verificationCondition = new VerificationCondition();
            if (StringUtils.hasText((String)documentClassName[i])) {
                verificationCondition.setDocumentClassName(documentClassName[i]);
            }
            if (documentCount != null) {
                verificationCondition.setDocumentCount(Integer.valueOf(documentCount[i].intValue()));
                verificationCondition.setConditionType(this.determineConditionType(conditionType[i], translator));
            }
            if (StringUtils.hasText((String)fileNameRegExp[i])) {
                verificationCondition.setFileNameRegExp(fileNameRegExp[i]);
            }
            verificationConditions.add(verificationCondition);
        }
        return verificationConditions;
    }

    private VerificationMode establishMode(String verificationMode, Translator translator) {
        ProcessVerificationMode mode;
        if (verificationMode.equalsIgnoreCase("process")) {
            mode = new ProcessVerificationMode();
        } else if (verificationMode.equalsIgnoreCase("activity")) {
            mode = new ActivityVerificationMode();
        } else if (verificationMode.equalsIgnoreCase("stage")) {
            mode = new StageVerificationMode();
        } else {
            throw new IllegalArgumentException(translator.getMessage("validator.verify-documents.mode.error") + " process, activity, stage.");
        }
        return mode;
    }

    private ConditionType determineConditionType(String conditionType, Translator translator) {
        if (conditionType.equals("=")) {
            return new EQCondition();
        }
        if (conditionType.equals("!=")) {
            return new NOTEQCondition();
        }
        if (conditionType.equals("<")) {
            return new LTCondition();
        }
        if (conditionType.equals("<=")) {
            return new LECondition();
        }
        if (conditionType.equals(">")) {
            return new GTCondition();
        }
        if (conditionType.equals(">=")) {
            return new GECondition();
        }
        throw new IllegalArgumentException(translator.getMessage("validator.verify-documents.operator.error") + " =, !=, <, <=, >, >=.");
    }

    private String getDocumentSuffix(Long count, Translator translator) {
        if (count == 0L) {
            return translator.getMessage("validator.verify-documents.suffix.many");
        }
        if (count == 1L) {
            return translator.getMessage("validator.verify-documents.suffix.one");
        }
        if (count >= 2L && count <= 4L) {
            return translator.getMessage("validator.verify-documents.suffix.few");
        }
        return translator.getMessage("validator.verify-documents.suffix.many");
    }

    private String getOperatorText(String operator, Translator translator) {
        return switch (operator) {
            case "=" -> translator.getMessage("validator.verify-documents.operator.equal");
            case "!=" -> translator.getMessage("validator.verify-documents.operator.not-equal");
            case "<" -> translator.getMessage("validator.verify-documents.operator.less");
            case "<=" -> translator.getMessage("validator.verify-documents.operator.less-equal");
            case ">" -> translator.getMessage("validator.verify-documents.operator.greater");
            case ">=" -> translator.getMessage("validator.verify-documents.operator.greater-equal");
            default -> throw new IllegalArgumentException(translator.getMessage("validator.verify-documents.operator.unknown") + operator);
        };
    }

    private int extractDocumentCount(String message, Translator translator) {
        if (message == null || message.isEmpty()) {
            return 0;
        }
        try {
            int endIndex;
            String searchPhrase = translator.getMessage("validator.verify-documents.attached") + " ";
            int startIndex = message.indexOf(searchPhrase);
            if (startIndex == -1) {
                return 0;
            }
            if ((startIndex += searchPhrase.length()) < (endIndex = message.indexOf(" " + translator.getMessage("validator.verify-documents.suffix.one"), startIndex))) {
                String countStr = message.substring(startIndex, endIndex).trim();
                return Integer.parseInt(countStr);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private String formatValidationItem(String documentClassName, Long documentCount, String conditionType, VerificationResult validationResult, Translator translator) {
        String suffix = this.getDocumentSuffix(documentCount, translator);
        String operator = this.getOperatorText(conditionType, translator);
        int currentCount = this.extractDocumentCount(validationResult.getMessage(), translator);
        return String.format("<li>- <b>%s</b> &ndash; %s %d %s (%s: %d)</li>", documentClassName, operator, documentCount, suffix, translator.getMessage("validator.verify-documents.current"), currentCount);
    }
}

