/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.servlets;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.documents.DocumentClassDto;
import com.suncode.cuf.common.documents.DocumentClassIndexDto;
import com.suncode.cuf.common.documents.DocumentDto;
import com.suncode.cuf.common.documents.servlets.MoveDocumentRequest;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/docs"})
public class DocumentsController {
    @Autowired
    private CUFCommonDocumentService documentsService;
    @Autowired
    private DocumentClassService docClassService;
    private static Translator translator;

    @RequestMapping(value={"classNames"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getDocClassNames() {
        List<DocumentClass> classes = this.documentsService.getAllDocClasses();
        ArrayList<String> classNames = new ArrayList<String>();
        for (DocumentClass docClass : classes) {
            classNames.add(docClass.getName());
        }
        return classNames;
    }

    @RequestMapping(value={"classIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Long> getDocClassIds() {
        List<DocumentClass> classes = this.documentsService.getAllDocClasses();
        ArrayList<Long> classIds = new ArrayList<Long>();
        for (DocumentClass docClass : classes) {
            classIds.add(docClass.getId());
        }
        return classIds;
    }

    @RequestMapping(value={"classIdsAndNames"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getDocClassIdsAndNames() {
        List<DocumentClass> classes = this.documentsService.getAllDocClasses();
        HashMap<Long, String> classIdsAndNames = new HashMap<Long, String>();
        for (DocumentClass docClass : classes) {
            classIdsAndNames.put(docClass.getId(), docClass.getName());
        }
        return classIdsAndNames;
    }

    @RequestMapping(value={"classIndexesIdsAndNames/{classId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getDocClassIndexesIdsAndNames(@PathVariable(value="classId") Long classId) {
        DocumentClass temp = (DocumentClass)this.docClassService.get((Serializable)classId, new String[]{"indexes"});
        Set indexes = temp.getIndexes();
        HashMap<Long, String> classIndexesIdsAndNames = new HashMap<Long, String>();
        for (DocumentClassIndex docClassIndexes : indexes) {
            classIndexesIdsAndNames.put(docClassIndexes.getId(), docClassIndexes.getName());
        }
        return classIndexesIdsAndNames;
    }

    @RequestMapping(value={"classSourceNames"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getClassSourceNames() {
        DocumentEventTypes[] enums;
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentEventTypes documentEventTypes : enums = DocumentEventTypes.values()) {
            result.add(documentEventTypes.name());
        }
        return result;
    }

    @RequestMapping(value={"classSources"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getClassSources(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        ArrayList resultList = new ArrayList();
        DocumentEventTypes[] documentEventTypes = DocumentEventTypes.values();
        for (int i = start.intValue(); i < documentEventTypes.length && i < limit; ++i) {
            if (!StringUtils.isBlank((String)query) && !documentEventTypes[i].name().toLowerCase().contains(query.toLowerCase())) continue;
            HashMap<String, String> classSource = new HashMap<String, String>();
            classSource.put("sourceName", documentEventTypes[i].name());
            classSource.put("translationName", this.translate(documentEventTypes[i].name()));
            resultList.add(classSource);
        }
        return new CountedResult((long)resultList.size(), resultList);
    }

    private String translate(String toTranslate) {
        if (null == translator) {
            translator = Translators.get(DocumentsController.class);
        }
        LocalizedString text = new LocalizedString(toTranslate, translator, new Object[0]);
        return text.getOptional();
    }

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassDto> getDocumentClasses(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.documentsService.getDocumentClasses(query, start, limit);
    }

    @RequestMapping(value={"docClassIndexList/{className}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexes(@PathVariable(value="className") String className, @RequestParam(required=false, defaultValue="") String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.documentsService.getDocumentClassIndexes(className, query, start, limit);
    }

    @RequestMapping(value={"classNameFromId/{classId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getDocClassNameFromId(@PathVariable(value="classId") String classId) {
        return this.documentsService.getDocumentClassName(Long.parseLong(classId));
    }

    @RequestMapping(value={"indexesNamesFromIds"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] getIndexesNamesFromIds(@RequestParam String className, @RequestParam(value="indexesIds[]") String[] indexesIds) {
        return this.documentsService.getIndexesNamesFromIds(className, indexesIds);
    }

    @RequestMapping(value={"docClassFromDocClassName/{docClassName}"}, method={RequestMethod.GET})
    @ResponseBody
    public DocumentClassDto getDocClassIdFromDocClassName(@PathVariable(value="docClassName") String docClassName) {
        String realDocClassName = this.documentsService.getDocumentClassName(docClassName);
        return this.documentsService.getDocumentClassDto(realDocClassName);
    }

    @RequestMapping(value={"/move"}, method={RequestMethod.POST})
    public ResponseEntity<String> move(@RequestBody MoveDocumentRequest cfg) {
        List<WfDocument> documents = this.documentsService.getDocumentsFromProcess(cfg.getSourceProcessId());
        if (documents.size() == 0) {
            return new ResponseEntity((Object)"", (HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        this.documentsService.attachDocumentsToProcess(documents, cfg.getTargetProcessId(), cfg.getUserName());
        this.documentsService.detachDocumentsFromProcess(documents, cfg.getSourceProcessId());
        String msg = String.join((CharSequence)", ", (CharSequence[])documents.stream().map(doc -> doc.getFile().getFileName()).toArray(String[]::new));
        return new ResponseEntity((Object)msg, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"documentFromProcess/{documentClassName}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentDto> getDocumentsFromProcessWithDocumentClass(@PathVariable(value="documentClassName") String documentClassName, @RequestParam String processId) {
        Long documentClassId = this.documentsService.getDocumentClassID(documentClassName);
        List<WfDocument> docFromProcessWithDocClass = this.documentsService.getDocumentsFromProcessWithDocumentClass(processId, documentClassId);
        List dataDocDto = docFromProcessWithDocClass.stream().map(wfDocument -> {
            Long fileId = wfDocument.getFile().getId();
            return DocumentDto.builder().fileId(fileId).build();
        }).collect(Collectors.toList());
        CountedResult countedResult = new CountedResult();
        countedResult.setData(dataDocDto);
        countedResult.setTotal((long)dataDocDto.size());
        return countedResult;
    }
}

